/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.example.servlet;

import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.webapp.BaseServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="Example", urlPatterns={"/Example"})
public class Example
extends BaseServlet {
    private static final String[] PROPERTIES = new String[]{"BrowserName", "BrowserVendor", "BrowserVersion", "DeviceType", "HardwareVendor", "IsTablet", "IsMobile", "IsCrawler", "ScreenInchesDiagonal", "ScreenPixelsWidth"};
    private static final String CSS_INCLUDE = "https://51degrees.com/Demos/examples.css";
    private static final Logger logger = LoggerFactory.getLogger(Example.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, Exception {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">");
        out.println("<title>51Degrees Pattern Example Servlet</title>");
        out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"https://51degrees.com/Demos/examples.css\" class=\"inline\"/>");
        out.println("<script src=\"51D/core.js\" > </script>");
        out.println("<script>new FODPO();</script>");
        out.println("</head>");
        out.println("<body>");
        out.println("<div class=\"content\">");
        out.println("<img src=\"" + this.getURL("image") + "\" alt=\"51Degrees logo\">");
        out.println("<h1>Java Pattern - Device Detection Example</h1>");
        this.printDatasetInformation(out, request);
        this.printHeadersTable(out, request, null);
        this.printProperties(out, request);
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void printHeadersTable(PrintWriter out, HttpServletRequest request, String[] specificHeaders) throws Exception {
        out.println("<table>");
        out.println("<tbody>");
        out.println("<th colspan=\"2\">");
        out.println("Relevant HTTP Headers Received");
        out.println("</th>");
        if (specificHeaders == null || specificHeaders.length == 0) {
            for (String header : super.getProvider((HttpServletRequest)request).dataSet.getHttpHeaders()) {
                out.println("<tr>");
                out.println("<td>" + header + "</td>");
                if (request.getHeader(header) != null) {
                    out.println("<td>" + request.getHeader(header) + "</td>");
                } else {
                    out.println("<td>header not set</td>");
                }
                out.println("</tr>");
            }
        } else {
            String[] filteredHeaders = this.filterRelevantHeaders(super.getProvider((HttpServletRequest)request).dataSet.getHttpHeaders(), specificHeaders);
            for (int i = 0; i < filteredHeaders.length; ++i) {
                out.println("<tr>");
                out.println("<td>" + filteredHeaders[i] + "</td>");
                if (request.getHeader(filteredHeaders[i]) != null) {
                    out.println("<td>" + request.getHeader(filteredHeaders[i]) + "</td>");
                } else {
                    out.println("<td>header not set</td>");
                }
                out.println("</tr>");
            }
        }
        out.println("<tbody>");
        out.println("<table>");
    }

    private void printProperties(PrintWriter out, HttpServletRequest request) throws IOException {
        out.println("<table>");
        out.println("<tbody>");
        out.println("<tr>");
        out.println("<th colspan=\"3\">Match Metrics</th>");
        out.println("<th rowspan=\"5\">");
        out.println("<a class=\"button\" target=\"_blank\" href=\"" + this.getURL("metrics") + "\">About Metrics</a>");
        out.println("</th>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Id</td>");
        out.println("<td colspan=\"2\">");
        out.println(super.getProvider(request).match(request).getDeviceId());
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Method</td>");
        out.println("<td colspan=\"2\">");
        out.println(super.getProvider(request).match(request).getMethod());
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Difference</td>");
        out.println("<td colspan=\"2\">");
        out.println(super.getProvider(request).match(request).getDifference());
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Rank</td>");
        out.println("<td colspan=\"2\">");
        out.println(super.getProvider(request).match(request).getSignature().getRank());
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<th colspan=\"3\">Device Properties</th>");
        out.println("<th rowspan=\"" + (PROPERTIES.length + 1) + "\">");
        out.println("<a class=\"button\" target=\"_blank\" href=\"" + this.getURL("properties") + "\">More Properties</a>");
        out.println("</th>");
        out.println("</tr>");
        for (String property : PROPERTIES) {
            out.println("<tr>");
            out.println("<td>");
            out.println("<a href=\"https://51degrees.com/resources/property-dictionary#" + property + "\">" + property + "</a>");
            out.println("</td>");
            Property pr = super.getProvider((HttpServletRequest)request).dataSet.get(property);
            if (pr != null) {
                Values values;
                if (pr.valueType != Property.PropertyValueType.JAVASCRIPT && (values = super.getMatch(request).getValues(pr.getName())) != null) {
                    int current = 0;
                    out.println("<td>");
                    for (Value value : values.getAll()) {
                        out.println(value);
                        if (current < values.count() - 1) {
                            out.println(", ");
                        }
                        ++current;
                    }
                    out.println("</td>");
                }
                out.println("<td>" + pr.valueType + "</td>");
            } else {
                out.println("<td>Switch Data Set</td><td>NULL</td>");
            }
            out.println("</tr>");
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    private String[] filterRelevantHeaders(String[] importantHeaders, String[] headersToFilter) {
        int importantHeadersLength = importantHeaders.length;
        int resultLength = headersToFilter.length;
        ArrayList<String> headers = new ArrayList<String>();
        if (resultLength <= 0) {
            return new String[0];
        }
        block0: for (int i = 0; i < resultLength; ++i) {
            for (int j = 0; j < importantHeadersLength; ++j) {
                if (!headersToFilter[i].equals(importantHeaders[j])) continue;
                headers.add(importantHeaders[j]);
                continue block0;
            }
        }
        return headers.toArray(new String[headers.size()]);
    }

    private void printDatasetInformation(PrintWriter out, HttpServletRequest request) throws Exception {
        out.println("<table>");
        out.println("<tbody>");
        out.println("<tr><th colspan=\"3\">Data Set Information</th></tr>");
        out.println("<tr>");
        out.println("<td>Dataset Initialisation Status: </td>");
        if (super.getProvider(request) != null) {
            out.println("<td>SUCCESS</td>");
        } else {
            out.println("<td>FAILED</td>");
        }
        out.println("<td rowspan=\"6\">");
        out.println("<a class=\"button\" href=\"" + this.getURL("compare") + "\" target=\"_blank\">Compare Data Options</a>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Dataset published: </td>");
        out.println("<td>" + super.getProvider((HttpServletRequest)request).dataSet.published + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Dataset next update: </td>");
        out.println("<td>" + super.getProvider((HttpServletRequest)request).dataSet.nextUpdate + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Dataset version: </td>");
        out.println("<td>" + super.getProvider((HttpServletRequest)request).dataSet.version + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Dataset name: </td>");
        out.println("<td>" + super.getProvider((HttpServletRequest)request).dataSet.getName() + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>Dataset device combinations: </td>");
        out.println("<td>" + super.getProvider((HttpServletRequest)request).dataSet.deviceCombinations + "</td>");
        out.println("</tr>");
        out.println("</tbody>");
        out.println("</table>");
    }

    private String getURL(String purpose) {
        String url = "https://51degrees.com";
        String utm_source = "utm_source=github";
        String utm_medium = "utm_medium=repository";
        String utm_content = "utm_content=example-pattern";
        String utm_campaign = "utm_campaign=java-open-source";
        if (purpose.equals("image")) {
            url = "https://51degrees.com/DesktopModules/FiftyOne/Distributor/Logo.ashx";
        } else if (purpose.equals("metrics")) {
            url = "https://51degrees.com/support/documentation/pattern";
        } else if (purpose.equals("compare")) {
            url = "https://51degrees.com/compare-data-options";
        } else if (purpose.equals("properties")) {
            url = "https://51degrees.com/resources/property-dictionary";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        sb.append("?");
        sb.append(utm_source);
        sb.append("&");
        sb.append(utm_medium);
        sb.append("&");
        sb.append(utm_content);
        sb.append("&");
        sb.append(utm_campaign);
        return sb.toString();
    }

    public String getServletInfo() {
        return "51Degrees API extending BaseServlet example.";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

