/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection;

import fiftyone.devicedetection.Enums;
import fiftyone.devicedetection.hash.engine.onpremise.flowelements.DeviceDetectionHashEngineBuilder;
import fiftyone.devicedetection.pattern.engine.onpremise.flowelements.DeviceDetectionPatternEngineBuilder;
import fiftyone.devicedetection.shared.flowelements.OnPremiseDeviceDetectionEngineBuilderBase;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.Constants;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.fiftyone.flowelements.FiftyOneAspectEngine;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageBuilder;
import fiftyone.pipeline.engines.flowelements.PrePackagedPipelineBuilderBase;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.HttpClient;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class DeviceDetectionOnPremisePipelineBuilder
extends PrePackagedPipelineBuilderBase<DeviceDetectionOnPremisePipelineBuilder> {
    protected boolean shareUsageEnabled = true;
    private String filename;
    private boolean createTempDataCopy;
    private byte[] engineData;
    private int concurrency = -1;
    private Integer difference = null;
    private Boolean allowUnmatched = null;
    private boolean autoUpdateEnabled = true;
    private String dataUpdateLicenseKey = null;
    private Constants.PerformanceProfiles performanceProfile = Constants.PerformanceProfiles.Balanced;
    private Enums.DeviceDetectionAlgorithm algorithm = Enums.DeviceDetectionAlgorithm.Pattern;
    private DataUpdateService dataUpdateService;
    private HttpClient httpClient;

    DeviceDetectionOnPremisePipelineBuilder(DataUpdateService dataUpdateService, HttpClient httpClient) {
        this(LoggerFactory.getILoggerFactory(), dataUpdateService, httpClient);
    }

    DeviceDetectionOnPremisePipelineBuilder(ILoggerFactory loggerFactory, DataUpdateService dataUpdateService, HttpClient httpClient) {
        super(loggerFactory);
        this.dataUpdateService = dataUpdateService;
        this.httpClient = httpClient;
    }

    DeviceDetectionOnPremisePipelineBuilder setFilename(String filename, boolean createTempDataCopy) throws Exception {
        this.filename = filename;
        this.createTempDataCopy = createTempDataCopy;
        if (filename.substring(filename.length() - 4).equalsIgnoreCase(".dat")) {
            this.algorithm = Enums.DeviceDetectionAlgorithm.Pattern;
        } else if (filename.substring(filename.length() - 5).equalsIgnoreCase(".trie")) {
            this.algorithm = Enums.DeviceDetectionAlgorithm.Hash;
        } else {
            throw new Exception("Unrecognised filename. Expected a '*.dat' pattern data file or '*.trie' hash data file.");
        }
        return this;
    }

    DeviceDetectionOnPremisePipelineBuilder setEngineData(byte[] data, Enums.DeviceDetectionAlgorithm algorithm) {
        this.engineData = data;
        this.algorithm = algorithm;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setShareUsage(boolean enabled) {
        this.shareUsageEnabled = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setAutoUpdate(boolean enabled) {
        this.autoUpdateEnabled = enabled;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDataUpdateLicenseKey(String key) {
        this.dataUpdateLicenseKey = key;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setPerformanceProfile(Constants.PerformanceProfiles profile) {
        this.performanceProfile = profile;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setDifference(int difference) {
        this.difference = difference;
        return this;
    }

    public DeviceDetectionOnPremisePipelineBuilder setAllowUnmatched(boolean allow) {
        this.allowUnmatched = allow;
        return this;
    }

    public Pipeline build() throws Exception {
        Object deviceDetectionEngine = null;
        switch (this.algorithm) {
            case Hash: {
                DeviceDetectionHashEngineBuilder hashBuilder = new DeviceDetectionHashEngineBuilder(this.loggerFactory, this.dataUpdateService);
                deviceDetectionEngine = this.configureAndBuild((OnPremiseDeviceDetectionEngineBuilderBase)hashBuilder);
                break;
            }
            case Pattern: {
                DeviceDetectionPatternEngineBuilder patternBuilder = new DeviceDetectionPatternEngineBuilder(this.loggerFactory, this.dataUpdateService);
                deviceDetectionEngine = this.configureAndBuild((OnPremiseDeviceDetectionEngineBuilderBase)patternBuilder);
                break;
            }
            default: {
                throw new PipelineConfigurationException("Unrecognised algorithm '" + this.algorithm.name() + "'.");
            }
        }
        if (deviceDetectionEngine != null) {
            if (this.shareUsageEnabled) {
                this.getFlowElements().add(new ShareUsageBuilder(this.loggerFactory, this.httpClient).build());
            }
        } else {
            throw new RuntimeException("Unexpected error creating device detection engine.");
        }
        this.getFlowElements().add(deviceDetectionEngine);
        return super.build();
    }

    private <TBuilder extends OnPremiseDeviceDetectionEngineBuilderBase<TBuilder, TEngine>, TEngine extends FiftyOneAspectEngine> TEngine configureAndBuild(OnPremiseDeviceDetectionEngineBuilderBase<TBuilder, TEngine> builder) throws Exception {
        if (this.resultsCache) {
            CacheConfiguration cacheConfig = new CacheConfiguration(this.resultsCacheSize);
            builder.setCache(cacheConfig);
        }
        builder.setAutoUpdate(this.autoUpdateEnabled);
        if (this.dataUpdateLicenseKey != null) {
            builder.setDataUpdateLicenseKey(this.dataUpdateLicenseKey);
        }
        builder.setPerformanceProfile(this.performanceProfile);
        if (this.concurrency > 1) {
            builder.setConcurrency(this.concurrency);
        }
        if (this.difference != null) {
            builder.setDifference(this.difference.intValue());
        }
        if (this.allowUnmatched != null) {
            builder.setAllowUnmatched(this.allowUnmatched.booleanValue());
        }
        FiftyOneAspectEngine engine = null;
        if (this.filename != null && !this.filename.isEmpty()) {
            engine = (FiftyOneAspectEngine)builder.build(this.filename, this.createTempDataCopy);
        } else if (this.engineData != null) {
            engine = (FiftyOneAspectEngine)builder.build(this.engineData);
        } else {
            throw new PipelineConfigurationException("No source for engine data. Use setFilename or setEngineData to configure this.");
        }
        return (TEngine)engine;
    }
}

