/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.geolocation.core;

import fiftyone.geolocation.core.JavaScriptResource;
import fiftyone.geolocation.core.RequestFormatter;
import fiftyone.geolocation.core.data.GeoEvidence;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.types.JavaScript;
import fiftyone.pipeline.engines.services.HttpClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class GeoEngineHelper {
    private static boolean tryAddCoordinates(Map<String, Object> evidence, GeoEvidence geoEvidence, String latitudeKey, String longitudeKey) {
        boolean found = false;
        if (evidence.containsKey(latitudeKey) && evidence.containsKey(longitudeKey)) {
            geoEvidence.setLatitude(evidence.get(latitudeKey).toString());
            geoEvidence.setLongitude(evidence.get(longitudeKey).toString());
            found = true;
        }
        return found;
    }

    public static GeoLookupResult performGeoLookup(FlowData data, HttpClient webClient, RequestFormatter requestFormatter) throws IOException {
        GeoEvidence geoEvidence;
        GeoLookupResult result = new GeoLookupResult();
        Map allEvidence = data.getEvidence().asKeyMap();
        boolean getServerSide = GeoEngineHelper.tryAddCoordinates(allEvidence, geoEvidence = new GeoEvidence(), "location.latitude", "location.longitude");
        getServerSide = getServerSide || GeoEngineHelper.tryAddCoordinates(allEvidence, geoEvidence, "cookie.51D_Pos_latitude", "cookie.51D_Pos_longitude");
        boolean bl = getServerSide = getServerSide || GeoEngineHelper.tryAddCoordinates(allEvidence, geoEvidence, "query.51D_Pos_latitude", "query.51D_Pos_longitude");
        if (getServerSide) {
            if (allEvidence.containsKey("server.client-ip")) {
                geoEvidence.setIpAddress((String)allEvidence.get("server.client-ip"));
            }
            URL url = requestFormatter.format(geoEvidence);
            HttpURLConnection connection = webClient.connect(url);
            result.geoServiceResponse = webClient.getResponseString(connection);
            connection.disconnect();
        } else {
            result.clientsideEvidenceJS = new JavaScript(JavaScriptResource.getJavaScript());
        }
        return result;
    }

    public static class GeoLookupResult {
        public String geoServiceResponse;
        public JavaScript clientsideEvidenceJS;
    }
}

