/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.geolocation.web.examples.servlet;

import fiftyone.geolocation.core.data.GeoData;
import fiftyone.geolocation.web.examples.shared.EmbedTomcat;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.exceptions.NoValueException;
import fiftyone.pipeline.web.services.FlowDataProviderCore;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;

public class Example
extends HttpServlet {
    private static final long serialVersionUID = -7420567024186859548L;
    FlowDataProviderCore flowDataProvider = new FlowDataProviderCore.Default();

    public static void main(String[] args) throws LifecycleException {
        EmbedTomcat.runWebApp((String)"geo-location.web.examples/geo-location.web.examples.servlet/src/main/webapp", (String)"geo-location.web.examples/geo-location.web.examples.servlet/target", (int)8080);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NoValueException {
        FlowData data = this.flowDataProvider.getFlowData(request);
        GeoData geo = (GeoData)data.get(GeoData.class);
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Servlet Example</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("<script src=\"/geo-location.web.examples.servlet/51Degrees.core.js\"></script>");
            AspectPropertyValue town = geo.getTown();
            AspectPropertyValue county = geo.getCounty();
            AspectPropertyValue state = geo.getState();
            AspectPropertyValue country = geo.getCountry();
            out.println("<h2>Example</h2>\n\n<div id=\"content\">\n    <p>\n        The following values are determined sever-side on the first request.\n        As the server has no location information to work from, these \n        values will all be unknown:\n    </p>\n    <dl>\n        <dt><strong>Country</strong></dt>\n        <dv>" + (county.hasValue() ? (String)county.getValue() : "Unknown: " + county.getNoValueMessage()) + "</dv>\n        <dt><strong>State</strong></dt>\n        <dv>" + (state.hasValue() ? (String)state.getValue() : "Unknown: " + state.getNoValueMessage()) + "</dv>\n        <dt><strong>County</strong></dt>\n        <dv>" + (country.hasValue() ? (String)country.getValue() : "Unknown: " + country.getNoValueMessage()) + "</dv>\n        <dt><strong>Town/City</strong></dt>\n        <dv>" + (town.hasValue() ? (String)town.getValue() : "Unknown: " + town.getNoValueMessage()) + "</dv>\n    </dl>   \n    <p>\n        When the button below is clicked, JavaScript running on the client-side will be used to obtain additional evidence (i.e. the location information from the device). If no additional information appears then it may indicate an external problem such as JavaScript being disabled in your browser.\n    </p>\n    <p>\n        Note that the accuracy of the information is dependent on the accuracy of the location data returned by your device. Any device that lacks GPS is likely to return a highly inaccurate result. Among devices with GPS, some have a significantly lower margin of error than others.\n    </p>\n    <button type=\"button\" onclick=\"buttonClicked()\">Use my location</button>\n</div>\n\n<script>\n    buttonClicked = function () {\n        // This function will fire when the JSON data object is updated\n        // with information from the server.\n        // The sequence is:\n        // 1. Response contains JavaScript property 'JavaScript'. This is not executed immediately on the client as it will prompt the user to allow access to location.\n        // 2. When the button is clicked, the fod.complete function is called, passing 'location' as the second parameter. This lets the code know that we want to execute\n        // any JavaScript needed to obtain the location data that is needed to determine the user's postal address details.\n        // 3. The execution of the location JavaScript triggers a background callback to the webserver that includes the new evidence (i.e. lat/lon).\n        // 4. The web server responds with new JSON data that contains the updated property values based on the new evidence.\n        // 5. The JavaScript integrates the new JSON data and fires the 'complete' callback function below, which then displays the results.\n        fod.complete(function (data) {\n            let fieldValues = [];\n            if (data.location) {\n                fieldValues.push([\"Country\", data.location.country]);\n                fieldValues.push([\"State\", data.location.state]);\n                fieldValues.push([\"County\", data.location.country]);\n                fieldValues.push([\"Town/City\", data.location.town]);\n            }\n            else {\n                fieldValue.push([\"Location data is empty. This probably means that something has gone wrong with the JavaScript evaluation.\", \"\"])\n            }\n            displayValues(fieldValues);\n        }, 'location');\n    }\n\n    function displayValues(fieldValues) {\n        var list = document.createElement('dl');\n        fieldValues.forEach(function (entry) {\n            var name = document.createElement('dt');\n            var value = document.createElement('dv');\n            var bold = document.createElement('strong');\n            var fieldname = document.createTextNode(entry[0]);\n            var fieldvalue = document.createTextNode(entry[1]);\n            bold.appendChild(fieldname);\n            name.appendChild(bold);\n            value.appendChild(fieldvalue);\n            list.appendChild(name);\n            list.appendChild(value);\n        });\n\n        var element = document.getElementById('content');\n        element.appendChild(list);\n    }\n</script>");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (NoValueException e) {
            e.printStackTrace();
        }
    }

    public String getServletInfo() {
        return "Short description";
    }
}

