/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.geolocation.web.examples.shared;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;

public class EmbedTomcat {
    public static Tomcat tomcat;

    public static Context startTomcat(String servletName, String urlPattern, HttpServlet servlet, int port) throws LifecycleException, IOException {
        tomcat = new Tomcat();
        tomcat.setBaseDir(Files.createTempDirectory("tomcat-", new FileAttribute[0]).toFile().getAbsolutePath());
        tomcat.setPort(port);
        String contextPath = "";
        String docBase = new File(".").getAbsolutePath();
        Context context = tomcat.addContext(contextPath, docBase);
        tomcat.addServlet(contextPath, servletName, (Servlet)servlet);
        context.addServletMappingDecoded(urlPattern, servletName);
        if (Integer.parseInt(System.getProperty("java.version").split("\\.")[0]) <= 9) {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            ((StandardContext)context).setDelegate(true);
        }
        tomcat.start();
        return context;
    }

    public static void stopTomcat() {
        try {
            tomcat.stop();
            tomcat.destroy();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    public static void runWebApp(String pathname, String workingDir, int port) throws LifecycleException {
        System.setProperty("logback.configurationFile", "./logback.xml");
        String contextPath = "";
        String webappDir = new File(pathname).getAbsolutePath();
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(workingDir);
        tomcat.setPort(port);
        tomcat.addWebapp(contextPath, webappDir);
        tomcat.start();
        System.out.format("Browse to http://localhost:%d using a 'private' window in your browser\nHit enter to stop tomcat:", port);
        new Scanner(System.in).nextLine();
        tomcat.stop();
    }

    public static void runServlet(HttpServlet servlet, String workingDir, String urlPattern, int port) throws LifecycleException {
        System.setProperty("logback.configurationFile", "./logback.xml");
        tomcat = new Tomcat();
        tomcat.setBaseDir(workingDir);
        tomcat.setPort(port);
        String contextPath = "";
        String docBase = new File(".").getAbsolutePath();
        Context context = tomcat.addContext(contextPath, docBase);
        tomcat.addServlet(contextPath, servlet.getClass().getSimpleName(), (Servlet)servlet);
        context.addServletMappingDecoded(urlPattern, servlet.getClass().getSimpleName());
        if (Integer.parseInt(System.getProperty("java.version").split("\\.")[0]) <= 9) {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            ((StandardContext)context).setDelegate(true);
        }
        tomcat.start();
        System.out.format("Browse to http://localhost:%d using a 'private' window in your browser\nHit enter to stop tomcat:", port);
        new Scanner(System.in).nextLine();
        tomcat.stop();
    }
}

