/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.data;

import fiftyone.pipeline.engines.fiftyone.data.CloseableIterable;
import java.util.Iterator;

public abstract class CollectionIterableBase<T>
implements CloseableIterable<T> {
    private final long size;

    public CollectionIterableBase(long size) {
        this.size = size;
    }

    @Override
    public Iterator<T> iterator() {
        return new CollectionIterator();
    }

    protected abstract T get(long var1);

    private class CollectionIterator
    implements Iterator<T> {
        private long index = -1L;

        @Override
        public boolean hasNext() {
            return this.index < CollectionIterableBase.this.size - 1L;
        }

        @Override
        public T next() {
            ++this.index;
            return CollectionIterableBase.this.get(this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

