/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.data;

import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.engines.data.AspectPropertyMetaDataDefault;
import fiftyone.pipeline.engines.fiftyone.data.ComponentMetaData;
import fiftyone.pipeline.engines.fiftyone.data.FiftyOneAspectPropertyMetaData;
import fiftyone.pipeline.engines.fiftyone.data.ValueMetaData;
import fiftyone.pipeline.engines.fiftyone.data.ValueMetaDataDefault;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FiftyOneAspectPropertyMetaDataDefault
extends AspectPropertyMetaDataDefault
implements FiftyOneAspectPropertyMetaData {
    private final String url;
    private final byte displayOrder;
    private final boolean mandatory;
    private final boolean list;
    private final boolean obsolete;
    private final boolean show;
    private final boolean showValues;
    private final String description;
    private final ComponentMetaData component;
    private final Iterable<ValueMetaDataDefault> values;
    private final ValueMetaDataDefault defaultValue;

    public FiftyOneAspectPropertyMetaDataDefault(String name, FlowElement<?, ?> element, String category, Class<?> type, List<String> dataTiersWherePresent, boolean available, String url, byte displayOrder, boolean mandatory, boolean list, boolean obsolete, boolean show, boolean showValues, String description, ComponentMetaData component, Iterable<ValueMetaDataDefault> values, ValueMetaDataDefault defaultValue) {
        super(name, element, category, type, dataTiersWherePresent, available);
        this.url = url;
        this.displayOrder = displayOrder;
        this.mandatory = mandatory;
        this.list = list;
        this.obsolete = obsolete;
        this.show = show;
        this.showValues = showValues;
        this.description = description;
        this.component = component;
        this.values = values;
        this.defaultValue = defaultValue;
        defaultValue.setProperty(this);
        for (ValueMetaDataDefault value : this.values) {
            value.setProperty(this);
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public byte getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public boolean getMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean getList() {
        return this.list;
    }

    @Override
    public boolean getObsolete() {
        return this.obsolete;
    }

    @Override
    public boolean getShow() {
        return this.show;
    }

    @Override
    public boolean getShowValues() {
        return this.showValues;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ComponentMetaData getComponent() {
        return this.component;
    }

    @Override
    public Iterable<ValueMetaData> getValues() {
        return () -> {
            final Iterator<ValueMetaDataDefault> innerValues = this.values.iterator();
            return new Iterator<ValueMetaData>(){

                @Override
                public boolean hasNext() {
                    return innerValues.hasNext();
                }

                @Override
                public ValueMetaData next() {
                    return (ValueMetaData)innerValues.next();
                }
            };
        };
    }

    @Override
    public ValueMetaData getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ValueMetaData getValue(String valueName) {
        for (ValueMetaData valueMetaData : this.values) {
            if (!valueMetaData.getName().equals(valueName)) continue;
            return valueMetaData;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

