/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.typed.TypedKey;
import fiftyone.pipeline.core.typed.TypedKeyDefault;
import fiftyone.pipeline.engines.data.AspectData;
import fiftyone.pipeline.engines.fiftyone.data.CloseableIterable;
import fiftyone.pipeline.engines.fiftyone.data.ComponentMetaData;
import fiftyone.pipeline.engines.fiftyone.data.FiftyOneAspectPropertyMetaData;
import fiftyone.pipeline.engines.fiftyone.data.ProfileMetaData;
import fiftyone.pipeline.engines.fiftyone.data.ValueMetaData;
import fiftyone.pipeline.engines.fiftyone.flowelements.FiftyOneAspectEngine;
import fiftyone.pipeline.engines.flowelements.OnPremiseAspectEngineBase;
import fiftyone.pipeline.util.Types;
import org.slf4j.Logger;

public abstract class FiftyOneOnPremiseAspectEngineBase<TData extends AspectData, TProperty extends FiftyOneAspectPropertyMetaData>
extends OnPremiseAspectEngineBase<TData, TProperty>
implements FiftyOneAspectEngine<TData, TProperty> {
    public FiftyOneOnPremiseAspectEngineBase(Logger logger, ElementDataFactory<TData> aspectDataFactory, String tempDataFilePath) {
        super(logger, aspectDataFactory, tempDataFilePath);
    }

    public TypedKey<TData> getTypedDataKey() {
        if (this.typedKey == null) {
            this.typedKey = new TypedKeyDefault(this.getElementDataKey(), Types.findSubClassParameterType((Object)this, FiftyOneOnPremiseAspectEngineBase.class, (int)0));
        }
        return this.typedKey;
    }

    @Override
    public abstract CloseableIterable<ProfileMetaData> getProfiles();

    @Override
    public ProfileMetaData getProfile(int profileId) throws Exception {
        try (CloseableIterable<ProfileMetaData> profiles = this.getProfiles();){
            for (ProfileMetaData profile : profiles) {
                if (profile.getProfileId() != profileId) continue;
                ProfileMetaData profileMetaData = profile;
                return profileMetaData;
            }
        }
        return null;
    }

    @Override
    public abstract CloseableIterable<ComponentMetaData> getComponents();

    @Override
    public ComponentMetaData getComponent(String name) throws Exception {
        try (CloseableIterable<ComponentMetaData> metaDataComponents = this.getComponents();){
            for (ComponentMetaData component : metaDataComponents) {
                if (!component.getName().equalsIgnoreCase(name)) continue;
                ComponentMetaData componentMetaData = component;
                return componentMetaData;
            }
        }
        return null;
    }

    @Override
    public abstract CloseableIterable<ValueMetaData> getValues();

    @Override
    public ValueMetaData getValue(String propertyName, String valueName) throws Exception {
        try (CloseableIterable<ValueMetaData> values = this.getValues();){
            for (ValueMetaData value : values) {
                if (!value.getProperty().getName().equalsIgnoreCase(propertyName) || !value.getName().equalsIgnoreCase(valueName)) continue;
                ValueMetaData valueMetaData = value;
                return valueMetaData;
            }
        }
        return null;
    }
}

