/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.core.data.ElementData;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaDataDefault;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.exceptions.NoValueException;
import fiftyone.pipeline.engines.fiftyone.data.SetHeadersData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class SetHeadersElement
extends FlowElementBase<SetHeadersData, ElementPropertyMetaData> {
    public static final String SET_HEADER_ELEMENT_DATAKEY = "set-headers";
    public static final String SET_HEADER_PREFIX = "SetHeader";
    public static final String SET_HEADER_PREFIX_LOWER_CASE = "setheader";
    private final EvidenceKeyFilter evidenceKeyFilter = new EvidenceKeyFilterWhitelist(new ArrayList());
    private final List<ElementPropertyMetaData> properties = Collections.singletonList(new ElementPropertyMetaDataDefault("ResponseHeaderDictionary", (FlowElement)this, "", HashMap.class, true));
    private final Hashtable<Pipeline, PipelineConfig> pipelineConfigs = new Hashtable();

    public SetHeadersElement(Logger logger, ElementDataFactory<SetHeadersData> elementDataFactory) {
        super(logger, elementDataFactory);
    }

    protected void processInternal(FlowData data) throws Exception {
        if (data == null) {
            throw new NullPointerException(FlowData.class.getName());
        }
        Pipeline pipeline = data.getPipeline();
        PipelineConfig config = this.pipelineConfigs.get(pipeline);
        if (config == null) {
            config = this.populateConfig(pipeline);
            config = this.pipelineConfigs.getOrDefault(pipeline, config);
        }
        SetHeadersData elementData = (SetHeadersData)data.getOrAdd(this.getElementDataKey(), this.getDataFactory());
        HashMap<String, String> responseHeaders = this.buildResponseHeaders(data, config);
        elementData.setResponseHeaderDictionary(responseHeaders);
    }

    public String getElementDataKey() {
        return SET_HEADER_ELEMENT_DATAKEY;
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return this.evidenceKeyFilter;
    }

    public List<ElementPropertyMetaData> getProperties() {
        return this.properties;
    }

    protected void managedResourcesCleanup() {
    }

    protected void unmanagedResourcesCleanup() {
    }

    private HashMap<String, String> buildResponseHeaders(FlowData data, PipelineConfig config) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        config.setHeaderProperties.forEach((k, v) -> {
            ElementData elementData = data.get(v.propertyMetaData.getElement().getElementDataKey());
            String headerValue = this.getHeaderValue(elementData.get(k));
            if (!headerValue.isEmpty() && !headerValue.equals("Unknown")) {
                String responseHeaderValue = (String)responseHeaders.get(v.responseHeaderName);
                if (responseHeaderValue != null) {
                    responseHeaderValue = responseHeaderValue + "," + headerValue;
                    responseHeaders.put(v.responseHeaderName, responseHeaderValue);
                } else {
                    responseHeaders.put(v.responseHeaderName, headerValue);
                }
            }
        });
        return responseHeaders;
    }

    private String getHeaderValue(Object propertyValue) {
        String result = "";
        if (propertyValue instanceof AspectPropertyValue && ((AspectPropertyValue)propertyValue).hasValue()) {
            try {
                Object value = ((AspectPropertyValue)propertyValue).getValue();
                if (value instanceof String) {
                    result = (String)value;
                }
            }
            catch (NoValueException e) {
                e.printStackTrace();
            }
        } else if (propertyValue instanceof String) {
            result = (String)propertyValue;
        }
        return result;
    }

    private PipelineConfig populateConfig(Pipeline pipeline) {
        PipelineConfig config = new PipelineConfig();
        pipeline.getElementAvailableProperties().forEach((k, v) -> v.forEach((p, m) -> {
            if (p.toLowerCase().startsWith(SET_HEADER_PREFIX_LOWER_CASE)) {
                PropertyDetails details = new PropertyDetails();
                details.propertyMetaData = m;
                details.responseHeaderName = this.getResponseHeader((String)p);
                config.setHeaderProperties.put((String)p, details);
            }
        }));
        return config;
    }

    private String getResponseHeader(String key) {
        if (!key.startsWith(SET_HEADER_PREFIX)) {
            throw new IllegalArgumentException(String.format("Property name '%s' does not start with 'SetHeader'", key));
        }
        if (key.length() <= SET_HEADER_PREFIX.length() + 1) {
            throw new IllegalArgumentException(String.format("Property name '%s' is not in the expected format (SetHeader[Component][HeaderName])", key));
        }
        for (int i = new String(SET_HEADER_PREFIX).length() + 1; i < key.length(); ++i) {
            if (!Character.isUpperCase(key.charAt(i))) continue;
            return key.substring(i).trim();
        }
        throw new IllegalArgumentException(String.format("Property name '%s' is not in the expected format (SetHeader[Component][HeaderName])", key));
    }

    protected class PropertyDetails {
        public ElementPropertyMetaData propertyMetaData;
        public String responseHeaderName;

        protected PropertyDetails() {
        }
    }

    protected class PipelineConfig {
        public Map<String, PropertyDetails> setHeaderProperties = new HashMap<String, PropertyDetails>();

        protected PipelineConfig() {
        }
    }
}

