/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements;

import fiftyone.pipeline.engines.fiftyone.exceptions.HttpException;
import fiftyone.pipeline.engines.fiftyone.flowelements.ShareUsageBase;
import fiftyone.pipeline.engines.services.DataUploader;
import fiftyone.pipeline.engines.services.DataUploaderHttp;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.trackers.Tracker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;

public class ShareUsageElement
extends ShareUsageBase {
    protected int httpSendTimeout = 5000;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected HttpClient httpClient;
    protected DataUploader dataUploader = new DataUploaderHttp(this.shareUsageUrl, this.headers, this.httpSendTimeout);
    protected XMLOutputFactory xmlOutputFactory;

    @Deprecated
    ShareUsageElement(Logger logger, HttpClient httpClient, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter) {
        this(logger, httpClient, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, "JSESSIONID");
    }

    @Deprecated
    ShareUsageElement(Logger logger, HttpClient httpClient, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter, String sessionCookieName) {
        this(logger, httpClient, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, sessionCookieName, null);
    }

    @Deprecated
    ShareUsageElement(Logger logger, HttpClient httpClient, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter, String sessionCookieName, Tracker tracker) {
        this(logger, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, sessionCookieName, tracker);
        this.httpClient = httpClient;
    }

    ShareUsageElement(Logger logger, double sharePercentage, int minimumEntriesPerMessage, int maximumQueueSize, int addTimeout, int takeTimeout, int repeatEvidenceIntervalMinutes, boolean trackSession, String shareUsageUrl, List<String> blockedHttpHeaders, List<String> includedQueryStringParameters, List<Map.Entry<String, String>> ignoreDataEvidenceFilter, String sessionCookieName, Tracker tracker) {
        super(logger, sharePercentage, minimumEntriesPerMessage, maximumQueueSize, addTimeout, takeTimeout, repeatEvidenceIntervalMinutes, trackSession, shareUsageUrl, blockedHttpHeaders, includedQueryStringParameters, ignoreDataEvidenceFilter, sessionCookieName, tracker);
        this.headers.put("Content-Type", "text/xml; charset=utf-8");
        this.headers.put("Content-Encoding", "gzip");
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        if (this.xmlOutputFactory.isPropertySupported("escapeCharacters")) {
            this.xmlOutputFactory.setProperty("escapeCharacters", true);
        }
    }

    @Override
    protected void sendUsageData() {
        this.logger.debug(threadMarker, "Send Usage Data");
        ArrayList<ShareUsageBase.ShareUsageData> allData = new ArrayList<ShareUsageBase.ShareUsageData>();
        do {
            this.logger.debug(threadMarker, "Queue size is {}", (Object)this.evidenceCollection.size());
            try {
                ShareUsageBase.ShareUsageData currentData;
                allData.clear();
                while (allData.size() < this.minEntriesPerMessage * 2 && (currentData = (ShareUsageBase.ShareUsageData)this.evidenceCollection.poll(this.takeTimeout, TimeUnit.MILLISECONDS)) != null) {
                    allData.add(currentData);
                }
                this.sendAsXML(allData);
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupted exception caught while waiting on share usage queue");
            }
            catch (Exception e) {
                this.logger.error("Exception sending usage data", (Throwable)e);
            }
        } while (this.evidenceCollection.size() >= this.minEntriesPerMessage || this.executor.isShutdown() && this.evidenceCollection.size() > 0);
        this.logger.debug(threadMarker, "Stopping sending. Queue size is {}", (Object)this.evidenceCollection.size());
    }

    protected void sendAsXML(List<ShareUsageBase.ShareUsageData> allData) throws Exception {
        this.logger.debug(threadMarker, "send {} usage elements", (Object)allData.size());
        if (Objects.nonNull(this.httpClient)) {
            this.legacySendAsXML(allData);
            return;
        }
        try (OutputStream os = this.dataUploader.getOutputStream();){
            this.streamXml(allData, os);
        }
        int code = this.dataUploader.getResponseCode();
        if (code != 200) {
            throw new Exception(String.format("Share Usage response code was %d ", code));
        }
        this.logger.debug(threadMarker, "Send elements done");
    }

    private void streamXml(List<ShareUsageBase.ShareUsageData> allData, OutputStream os) throws XMLStreamException {
        XMLStreamWriter writer = this.xmlOutputFactory.createXMLStreamWriter(os, "UTF-8");
        writer.writeStartElement("Devices");
        writer.writeAttribute("version", "1.1");
        for (ShareUsageBase.ShareUsageData data : allData) {
            this.writeXmlData(writer, data);
        }
        writer.writeEndElement();
        writer.close();
    }

    protected void writeXmlData(XMLStreamWriter writer, ShareUsageBase.ShareUsageData data) throws XMLStreamException {
        writer.writeStartElement("Device");
        this.writeXmlElement(writer, "Version", this.coreVersion);
        this.writeXmlElement(writer, "Product", "Pipeline");
        for (String string : this.getFlowElements()) {
            this.writeXmlElement(writer, "FlowElement", string);
        }
        this.writeXmlElement(writer, "Language", "java");
        this.writeXmlElement(writer, "LanguageVersion", this.languageVersion);
        this.writeXmlElement(writer, "ServerIP", this.getHostAddress());
        this.writeXmlElement(writer, "Platform", this.osVersion);
        this.writeXmlElement(writer, "SessionId", data.sessionId);
        this.writeXmlElement(writer, "Sequence", String.valueOf(data.sequence));
        this.writeXmlElement(writer, "DateSent", DATE_FMT.format(new Date()));
        this.writeXmlElement(writer, "ClientIP", data.clientIP);
        for (Map.Entry entry : data.evidenceData.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ReplacedString replacedString = new ReplacedString((String)entry2.getValue());
                if (((String)entry.getKey()).length() > 0) {
                    writer.writeStartElement((String)entry.getKey());
                    writer.writeAttribute("Name", (String)entry2.getKey());
                } else {
                    writer.writeStartElement((String)entry2.getKey());
                }
                if (replacedString.isReplaced()) {
                    writer.writeAttribute("replaced", "true");
                }
                if (replacedString.isTruncated()) {
                    writer.writeAttribute("truncated", "true");
                }
                writer.writeCharacters(replacedString.toString());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    protected void writeXmlElement(XMLStreamWriter writer, String elementName, String elementContent) throws XMLStreamException {
        if (elementContent != null) {
            writer.writeStartElement(elementName);
            writer.writeCharacters(elementContent);
            writer.writeEndElement();
        }
    }

    protected void legacySendAsXML(List<ShareUsageBase.ShareUsageData> allData) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            this.streamXml(allData, os);
        }
        HttpURLConnection connection = this.httpClient.connect(new URL(this.shareUsageUrl.trim()));
        String response = this.httpClient.postData(connection, this.headers, baos.toByteArray());
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage() + "data: '" + response + "'";
        if (responseCode != 200) {
            throw new HttpException(responseCode, responseMessage);
        }
    }

    public static class ReplacedString {
        static final Set<Integer> VALID_XML_CHARS = Stream.of(IntStream.range(32, 127), IntStream.range(160, 256)).flatMapToInt(i -> i).boxed().collect(Collectors.toCollection(HashSet::new));
        static final Boolean[] IS_VALID_XML_CHAR = (Boolean[])IntStream.range(0, 256).mapToObj(VALID_XML_CHARS::contains).toArray(Boolean[]::new);
        static final int MAX_LENGTH = 512;
        private boolean replaced;
        private boolean truncated;
        private final StringBuilder builder;

        public ReplacedString(String text) {
            if (Objects.isNull(text) || text.length() == 0) {
                this.builder = new StringBuilder(0);
            } else {
                this.builder = new StringBuilder(Math.min(text.length(), 512));
                this.truncated = text.length() > 512;
                text.chars().limit(512L).forEach(c -> {
                    if (c < IS_VALID_XML_CHAR.length && IS_VALID_XML_CHAR[c].booleanValue()) {
                        this.builder.append((char)c);
                    } else {
                        this.builder.append('\ufffd');
                        this.replaced = true;
                    }
                });
            }
        }

        public boolean isReplaced() {
            return this.replaced;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

