/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.flowelements.interop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LibLoader {
    private static OS getOs() throws UnsupportedOperationException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("nux") || os.contains("nix")) {
            return OS.UNIX;
        }
        if (os.contains("mac")) {
            return OS.MAC;
        }
        throw new UnsupportedOperationException(String.format("Unsupported Operating System '%s'. Please contact support@51degrees.com with details of your Operating System.", System.getProperty("os.name")));
    }

    private static String getArch() throws UnsupportedOperationException {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("arm")) {
            return "arm";
        }
        if (arch.contains("aarch64")) {
            return "aarch64";
        }
        if (arch.contains("64")) {
            return "x64";
        }
        if (arch.contains("32") || arch.contains("86")) {
            return "x86";
        }
        throw new UnsupportedOperationException(String.format("Unsupported processor architecture '%s'. Please contact support@51degrees.com with details of your architecture.", System.getProperty("os.arch")));
    }

    public static String getLibName(Class<?> engineClass) {
        return engineClass.getSimpleName() + "-" + LibLoader.getOs().toString() + "-" + LibLoader.getArch() + LibLoader.getOs().getExtension();
    }

    public static void load(Class<?> engineClass) throws IOException, UnsupportedOperationException {
        File nativeLibraryFile = LibLoader.copyResource(engineClass, LibLoader.getLibName(engineClass));
        try {
            System.load(nativeLibraryFile.getAbsolutePath());
        }
        finally {
            nativeLibraryFile.delete();
        }
    }

    private static File copyResource(Class<?> engineClass, String libName) throws IOException {
        byte[] buffer = new byte[1024];
        File temp = File.createTempFile(libName, "");
        try (InputStream in = engineClass.getResourceAsStream("/" + libName);){
            if (in == null) {
                throw new UnsatisfiedLinkError(String.format("Could not find the resource '%s'. Check the resource exists in the '%s' package or is present in the src/main/resources folder.", libName, engineClass.getSimpleName()));
            }
            try (FileOutputStream fos = new FileOutputStream(temp);){
                int read;
                while ((read = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (Exception ex) {
            throw new IOException(String.format("Could not copy resource '%s' to file '%s'. Check file system permissions.", libName, temp.getAbsolutePath()), ex);
        }
        return temp;
    }

    static enum OS {
        WINDOWS,
        UNIX,
        MAC,
        OTHER;


        public String toString() {
            switch (this) {
                case UNIX: {
                    return "linux";
                }
                case WINDOWS: {
                    return "windows";
                }
                case MAC: {
                    return "mac";
                }
            }
            return "unsupported";
        }

        String getExtension() {
            switch (this) {
                case WINDOWS: {
                    return ".dll";
                }
                case MAC: {
                    return ".dylib";
                }
            }
            return ".so";
        }
    }
}

