/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.engines.fiftyone.trackers;

import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.trackers.TrackerBase;
import java.util.Date;

public class ShareUsageTracker
extends TrackerBase<Date> {
    private final EvidenceKeyFilter filter;
    private final long interval;

    public ShareUsageTracker(CacheConfiguration configuration, long intervalMillis, EvidenceKeyFilter filter) {
        super(configuration);
        this.interval = intervalMillis;
        this.filter = filter;
    }

    protected Date newValue(FlowData data) {
        return new Date();
    }

    protected boolean match(FlowData data, Date value) {
        Date now = new Date();
        return value.getTime() <= now.getTime() - this.interval;
    }

    protected EvidenceKeyFilter getFilter() {
        return this.filter;
    }
}

