/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.javascriptbuilder.flowelements;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaDataDefault;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.exceptions.PipelineDataException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.javascriptbuilder.data.JavaScriptBuilderData;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderDataInternal;
import fiftyone.pipeline.javascriptbuilder.templates.JavaScriptResource;
import fiftyone.pipeline.jsonbuilder.data.JsonBuilderData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JavaScriptBuilderElement
extends FlowElementBase<JavaScriptBuilderData, ElementPropertyMetaData> {
    protected String host;
    protected String endpoint;
    protected String protocol;
    protected String contextRoot;
    protected final String objName;
    protected final boolean enableCookies;
    private final Mustache mustache;

    public JavaScriptBuilderElement(Logger logger, ElementDataFactory<JavaScriptBuilderData> elementDataFactory, String endpoint, String objName, boolean enableCookies, String host, String protocol) {
        this(logger, elementDataFactory, endpoint, objName, enableCookies, host, protocol, null);
    }

    public JavaScriptBuilderElement(Logger logger, ElementDataFactory<JavaScriptBuilderData> elementDataFactory, String endpoint, String objName, boolean enableCookies, String host, String protocol, String contextRoot) {
        super(logger, elementDataFactory);
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/fiftyone/pipeline/javascriptbuilder/templates/JavaScriptResource.mustache");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.mustache = mf.compile((Reader)reader, "template");
        this.host = host;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.objName = objName.isEmpty() ? "fod" : objName;
        this.enableCookies = enableCookies;
        this.contextRoot = contextRoot;
    }

    protected void processInternal(FlowData data) throws Exception {
        String jsonObject;
        boolean supportsPromises;
        TryGetResult protocolEvidence;
        TryGetResult contextRoot;
        TryGetResult hostEvidence;
        String reqHost = this.host;
        String reqProtocol = this.protocol;
        if ((reqHost == null || reqHost.isEmpty()) && (hostEvidence = data.tryGetEvidence("header.Host", String.class)).hasValue()) {
            reqHost = (String)hostEvidence.getValue();
        }
        if ((this.contextRoot == null || this.contextRoot.isEmpty()) && (contextRoot = data.tryGetEvidence("server.contextroot", String.class)).hasValue()) {
            this.contextRoot = (String)contextRoot.getValue();
        }
        if ((reqProtocol == null || reqProtocol.isEmpty()) && (protocolEvidence = data.tryGetEvidence("header.protocol", String.class)).hasValue()) {
            reqProtocol = (String)protocolEvidence.getValue();
        }
        if (reqProtocol == null || reqProtocol.isEmpty()) {
            reqProtocol = "https";
        }
        try {
            AspectPropertyValue supportsPromisesValue = (AspectPropertyValue)data.getAs("Promise", AspectPropertyValue.class);
            supportsPromises = supportsPromisesValue.hasValue() && supportsPromisesValue.getValue() == "Full";
        }
        catch (PipelineDataException e) {
            supportsPromises = false;
        }
        try {
            jsonObject = ((JsonBuilderData)data.get(JsonBuilderData.class)).getJson();
        }
        catch (PipelineDataException e) {
            throw new PipelineConfigurationException("Json data is missing, make sure there is a JsonBuilder element before this JavaScriptBuilderElement in the pipeline", (Throwable)e);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        Map queryEvidence = data.getEvidence().asKeyMap();
        for (Map.Entry entry : queryEvidence.entrySet()) {
            if (!((String)entry.getKey()).startsWith("query")) continue;
            parameters.add(((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1) + "=" + entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (int s = 0; s < parameters.size(); ++s) {
            sb.append(URLEncoder.encode((String)parameters.get(s), "UTF-8"));
            if (s >= parameters.size() - 1) continue;
            sb.append("&");
        }
        String queryParams = sb.toString();
        String url = null;
        if (!(reqProtocol == null || reqProtocol.isEmpty() || reqHost == null || reqHost.isEmpty() || this.endpoint == null || this.endpoint.isEmpty())) {
            boolean contextRootPopulated;
            boolean bl = contextRootPopulated = this.contextRoot != null && !this.contextRoot.isEmpty() && this.contextRoot != "/";
            if (this.endpoint.charAt(0) != '/') {
                this.endpoint = "/" + this.endpoint;
            }
            if (contextRootPopulated && this.contextRoot.charAt(0) != '/') {
                this.contextRoot = "/" + this.contextRoot;
            }
            if (reqHost.charAt(reqHost.length() - 1) == '/') {
                reqHost = reqHost.substring(0, reqHost.length() - 1);
            }
            if (contextRootPopulated && this.contextRoot.charAt(this.contextRoot.length() - 1) == '/') {
                this.contextRoot = this.contextRoot.substring(0, this.contextRoot.length() - 1);
            }
            url = reqProtocol + "://" + reqHost + (contextRootPopulated ? this.contextRoot : "") + this.endpoint + (queryParams.isEmpty() ? "" : "?" + queryParams);
        }
        this.buildJavaScript(data, jsonObject, supportsPromises, url);
    }

    public String getElementDataKey() {
        return "javascript-builder";
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return new EvidenceKeyFilterWhitelist(Arrays.asList("header.Host", "header.protocol", "query.fod-js-object-name", "server.contextroot"), String.CASE_INSENSITIVE_ORDER);
    }

    public List<ElementPropertyMetaData> getProperties() {
        return Collections.singletonList(new ElementPropertyMetaDataDefault("javascript", (FlowElement)this, "javascript", String.class, true));
    }

    protected void managedResourcesCleanup() {
    }

    protected void unmanagedResourcesCleanup() {
    }

    private void buildJavaScript(FlowData data, String jsonObject, boolean supportsPromises, String url) {
        JavaScriptBuilderDataInternal elementData = (JavaScriptBuilderDataInternal)data.getOrAdd(this.getElementDataKey(), this.getDataFactory());
        TryGetResult res = data.tryGetEvidence("query.fod-js-object-name", String.class);
        String objectName = !res.hasValue() || ((String)res.getValue()).isEmpty() ? this.objName : (String)res.getValue();
        boolean updateEnabled = url != null && !url.isEmpty();
        boolean hasDelayedProperties = jsonObject != null && jsonObject.contains("delayexecution");
        JavaScriptResource javaScriptObj = new JavaScriptResource(objectName, jsonObject, supportsPromises, url, this.enableCookies, updateEnabled, hasDelayedProperties);
        StringWriter stringWriter = new StringWriter();
        this.mustache.execute((Writer)stringWriter, javaScriptObj.asMap());
        String content = stringWriter.toString();
        elementData.setJavaScript(content);
    }
}

