/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.javascriptbuilder.flowelements;

import fiftyone.pipeline.annotations.DefaultValue;
import fiftyone.pipeline.annotations.ElementBuilder;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.javascriptbuilder.data.JavaScriptBuilderData;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderDataInternal;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

@ElementBuilder
public class JavaScriptBuilderElementBuilder {
    public static final boolean ENABLE_COOKIES = true;
    private final ILoggerFactory loggerFactory;
    private final Logger logger;
    protected String host = "";
    protected String endpoint = "";
    protected String protocol = "";
    protected String contextRoot = "";
    protected String objName = "";
    private boolean enableCookies = true;

    public JavaScriptBuilderElementBuilder(ILoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = loggerFactory.getLogger(JavaScriptBuilderElementBuilder.class.getName());
    }

    @DefaultValue(value="The host from the request")
    public JavaScriptBuilderElementBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    @DefaultValue(value="Empty string")
    public JavaScriptBuilderElementBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @DefaultValue(value="Value from evidence server.contextroot")
    public JavaScriptBuilderElementBuilder setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        return this;
    }

    @DefaultValue(value="The protocol from the request")
    public JavaScriptBuilderElementBuilder setProtocol(String protocol) {
        if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new PipelineConfigurationException("Invalid protocol in configuration (" + protocol + "), must be 'http' or https'");
        }
        this.protocol = protocol;
        return this;
    }

    @DefaultValue(value="fod")
    public JavaScriptBuilderElementBuilder setObjectName(String objName) {
        Pattern pattern = Pattern.compile("[a-zA-Z_$][0-9a-zA-Z_$]*");
        Matcher match = pattern.matcher(objName);
        if (!match.matches()) {
            PipelineConfigurationException ex = new PipelineConfigurationException("JavaScriptBuilder ObjectName is invalid. This must be a valid JavaScript type identifier.");
            throw ex;
        }
        this.objName = objName;
        return this;
    }

    @DefaultValue(booleanValue=true)
    public JavaScriptBuilderElementBuilder setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
        return this;
    }

    public JavaScriptBuilderElement build() {
        return new JavaScriptBuilderElement(this.loggerFactory.getLogger(JavaScriptBuilderElement.class.getName()), new ElementDataFactory<JavaScriptBuilderData>(){

            public JavaScriptBuilderData create(FlowData flowData, FlowElement<JavaScriptBuilderData, ?> flowElement) {
                return new JavaScriptBuilderDataInternal(JavaScriptBuilderElementBuilder.this.loggerFactory.getLogger(JavaScriptBuilderDataInternal.class.getName()), flowData);
            }
        }, this.endpoint, this.objName, this.enableCookies, this.host, this.protocol, this.contextRoot);
    }
}

