/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.javascriptbuilder.flowelements;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import fiftyone.pipeline.core.data.ElementPropertyMetaData;
import fiftyone.pipeline.core.data.ElementPropertyMetaDataDefault;
import fiftyone.pipeline.core.data.EvidenceKeyFilter;
import fiftyone.pipeline.core.data.EvidenceKeyFilterWhitelist;
import fiftyone.pipeline.core.data.FlowData;
import fiftyone.pipeline.core.data.TryGetResult;
import fiftyone.pipeline.core.data.factories.ElementDataFactory;
import fiftyone.pipeline.core.exceptions.PipelineConfigurationException;
import fiftyone.pipeline.core.exceptions.PipelineDataException;
import fiftyone.pipeline.core.flowelements.FlowElement;
import fiftyone.pipeline.core.flowelements.FlowElementBase;
import fiftyone.pipeline.engines.data.AspectPropertyValue;
import fiftyone.pipeline.engines.exceptions.PropertyMissingException;
import fiftyone.pipeline.javascriptbuilder.data.JavaScriptBuilderData;
import fiftyone.pipeline.javascriptbuilder.flowelements.JavaScriptBuilderDataInternal;
import fiftyone.pipeline.javascriptbuilder.templates.JavaScriptResource;
import fiftyone.pipeline.jsonbuilder.data.JsonBuilderData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;

public class JavaScriptBuilderElement
extends FlowElementBase<JavaScriptBuilderData, ElementPropertyMetaData> {
    protected String host;
    protected String endpoint;
    protected String protocol;
    protected String contextRoot;
    protected final String objName;
    protected final boolean enableCookies;
    private final Mustache mustache;

    public JavaScriptBuilderElement(Logger logger, ElementDataFactory<JavaScriptBuilderData> elementDataFactory, String endpoint, String objName, boolean enableCookies, String host, String protocol) {
        this(logger, elementDataFactory, endpoint, objName, enableCookies, host, protocol, null);
    }

    public JavaScriptBuilderElement(Logger logger, ElementDataFactory<JavaScriptBuilderData> elementDataFactory, String endpoint, String objName, boolean enableCookies, String host, String protocol, String contextRoot) {
        super(logger, elementDataFactory);
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/fiftyone/pipeline/javascriptbuilder/templates/JavaScriptResource.mustache");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.mustache = mf.compile((Reader)reader, "template");
        this.host = host;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.objName = objName.isEmpty() ? "fod" : objName;
        this.enableCookies = enableCookies;
        this.contextRoot = contextRoot;
    }

    protected void processInternal(FlowData data) throws Exception {
        String reqHost = this.getHost(data);
        String reqProtocol = this.getProtocol(data);
        boolean supportsPromises = this.getSupportsPromises(data);
        if (this.contextRoot == null || this.contextRoot.isEmpty()) {
            this.contextRoot = this.getContextRoot(data);
        }
        String jsonObject = this.getJsonObject(data);
        Map<String, String> parameters = this.getParameters(data);
        String queryParams = this.getQueryParams(parameters);
        String url = this.getUrl(reqProtocol, reqHost, queryParams);
        String sessionId = this.getSessionId(data);
        Integer sequence = this.getSequence(data);
        String serializedParameters = this.serializeParameters(parameters);
        this.buildJavaScript(data, jsonObject, supportsPromises, url, serializedParameters, sessionId, sequence);
    }

    public String getElementDataKey() {
        return "javascript-builder";
    }

    public EvidenceKeyFilter getEvidenceKeyFilter() {
        return new EvidenceKeyFilterWhitelist(Arrays.asList("header.Host", "header.protocol", "query.fod-js-object-name", "query.fod-js-enable-cookies", "server.contextroot"), String.CASE_INSENSITIVE_ORDER);
    }

    public List<ElementPropertyMetaData> getProperties() {
        return Collections.singletonList(new ElementPropertyMetaDataDefault("javascript", (FlowElement)this, "javascript", String.class, true));
    }

    protected void managedResourcesCleanup() {
    }

    protected void unmanagedResourcesCleanup() {
    }

    private String getHost(FlowData data) {
        TryGetResult hostEvidence;
        String reqHost = this.host;
        if ((reqHost == null || reqHost.isEmpty()) && (hostEvidence = data.tryGetEvidence("header.Host", String.class)).hasValue()) {
            reqHost = (String)hostEvidence.getValue();
        }
        return reqHost;
    }

    private String getProtocol(FlowData data) {
        String reqProtocol = this.protocol;
        if (reqProtocol == null || reqProtocol.isEmpty()) {
            TryGetResult protocolEvidence = data.tryGetEvidence("header.protocol", String.class);
            reqProtocol = protocolEvidence.hasValue() ? (String)protocolEvidence.getValue() : "https";
        }
        return reqProtocol;
    }

    private boolean getSupportsPromises(FlowData data) {
        boolean supportsPromises;
        try {
            AspectPropertyValue supportsPromisesValue = (AspectPropertyValue)data.getAs("Promise", AspectPropertyValue.class);
            supportsPromises = supportsPromisesValue.hasValue() && supportsPromisesValue.getValue() == "Full";
        }
        catch (PipelineDataException | PropertyMissingException e) {
            supportsPromises = false;
        }
        return supportsPromises;
    }

    private String getContextRoot(FlowData data) {
        String root = null;
        TryGetResult contextRoot = data.tryGetEvidence("server.contextroot", String.class);
        if (contextRoot.hasValue()) {
            root = (String)contextRoot.getValue();
        }
        return root;
    }

    private String getJsonObject(FlowData data) {
        String jsonObject;
        try {
            jsonObject = ((JsonBuilderData)data.get(JsonBuilderData.class)).getJson();
        }
        catch (PipelineDataException e) {
            throw new PipelineConfigurationException("Json data is missing, make sure there is a JsonBuilder element before this JavaScriptBuilderElement in the pipeline", (Throwable)e);
        }
        return jsonObject;
    }

    private Map<String, String> getParameters(FlowData data) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map queryEvidence = data.getEvidence().asKeyMap();
        for (Map.Entry entry : queryEvidence.entrySet()) {
            if (!((String)entry.getKey()).startsWith("query")) continue;
            String key = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1);
            key = URLEncoder.encode(key, "UTF-8");
            String value = URLEncoder.encode(entry.getValue().toString(), "UTF-8");
            parameters.put(key, value);
        }
        return parameters;
    }

    private String getQueryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            sb.append(key);
            sb.append("=");
            sb.append(parameters.get(key));
            sb.append("&");
        }
        sb.deleteCharAt(sb.lastIndexOf("&"));
        return sb.toString();
    }

    private String serializeParameters(Map<String, String> parameters) {
        JSONObject jsonObject = new JSONObject(parameters);
        return jsonObject.toString(0);
    }

    private String getUrl(String protocol, String host, String queryParams) {
        String url = null;
        if (!(protocol == null || protocol.isEmpty() || host == null || host.isEmpty() || this.endpoint == null || this.endpoint.isEmpty())) {
            boolean contextRootPopulated;
            boolean bl = contextRootPopulated = this.contextRoot != null && !this.contextRoot.isEmpty() && !this.contextRoot.equals("/");
            if (this.endpoint.charAt(0) != '/') {
                this.endpoint = "/" + this.endpoint;
            }
            if (contextRootPopulated && this.contextRoot.charAt(0) != '/') {
                this.contextRoot = "/" + this.contextRoot;
            }
            if (host.charAt(host.length() - 1) == '/') {
                host = host.substring(0, host.length() - 1);
            }
            if (contextRootPopulated && this.contextRoot.charAt(this.contextRoot.length() - 1) == '/') {
                this.contextRoot = this.contextRoot.substring(0, this.contextRoot.length() - 1);
            }
            url = protocol + "://" + host + (contextRootPopulated ? this.contextRoot : "") + this.endpoint + (queryParams.isEmpty() ? "" : "?" + queryParams);
        }
        return url;
    }

    private String getSessionId(FlowData data) {
        String sessionId = "";
        TryGetResult trySessionId = data.tryGetEvidence("query.session-id", String.class);
        if (trySessionId.hasValue()) {
            sessionId = (String)trySessionId.getValue();
        }
        return sessionId;
    }

    private Integer getSequence(FlowData data) {
        Integer sequence = 1;
        TryGetResult trySequence = data.tryGetEvidence("query.sequence", Integer.class);
        if (trySequence.hasValue()) {
            sequence = (Integer)trySequence.getValue();
        }
        return sequence;
    }

    private void buildJavaScript(FlowData data, String jsonObject, boolean supportsPromises, String url, String parameters, String sessionId, int sequence) {
        JavaScriptBuilderDataInternal elementData = (JavaScriptBuilderDataInternal)data.getOrAdd(this.getElementDataKey(), this.getDataFactory());
        TryGetResult res = data.tryGetEvidence("query.fod-js-object-name", String.class);
        String objectName = !res.hasValue() || ((String)res.getValue()).isEmpty() ? this.objName : (String)res.getValue();
        TryGetResult cookieVal = data.tryGetEvidence("query.fod-js-enable-cookies", String.class);
        boolean cookies = !cookieVal.hasValue() || ((String)cookieVal.getValue()).isEmpty() ? this.enableCookies : Boolean.parseBoolean((String)cookieVal.getValue());
        boolean updateEnabled = url != null && !url.isEmpty();
        boolean hasDelayedProperties = jsonObject != null && jsonObject.contains("delayexecution");
        JavaScriptResource javaScriptObj = new JavaScriptResource(objectName, jsonObject, sessionId, sequence, supportsPromises, url, parameters, cookies, updateEnabled, hasDelayedProperties);
        StringWriter stringWriter = new StringWriter();
        this.mustache.execute((Writer)stringWriter, javaScriptObj.asMap());
        String content = stringWriter.toString();
        elementData.setJavaScript(content);
    }
}

