/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web.mvc.components;

import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.DataUpdateServiceDefault;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.web.StartupHelpers;
import fiftyone.pipeline.web.mvc.components.FlowDataProvider;
import fiftyone.pipeline.web.mvc.configuration.FiftyOneInterceptorConfig;
import fiftyone.pipeline.web.mvc.services.ClientsidePropertyService;
import fiftyone.pipeline.web.mvc.services.FiftyOneJSService;
import fiftyone.pipeline.web.mvc.services.PipelineResultService;
import fiftyone.pipeline.web.mvc.services.UACHService;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class FiftyOneInterceptor
extends HandlerInterceptorAdapter {
    public Pipeline pipeline;
    private final PipelineResultService resultService;
    private final FlowDataProvider flowDataProvider;
    private final ClientsidePropertyService clientsidePropertyService;
    private final FiftyOneJSService fiftyOneJsService;
    private final UACHService uachService;

    @Autowired
    public FiftyOneInterceptor(FiftyOneInterceptorConfig config, PipelineResultService resultService, FlowDataProvider flowDataProvider, ClientsidePropertyService clientsidePropertyService, FiftyOneJSService fiftyOneJsService, UACHService uachService) throws RuntimeException {
        this.resultService = resultService;
        this.clientsidePropertyService = clientsidePropertyService;
        this.flowDataProvider = flowDataProvider;
        this.fiftyOneJsService = fiftyOneJsService;
        this.uachService = uachService;
        String configFileName = config.getDataFilePath();
        if (configFileName == null || configFileName.isEmpty()) {
            configFileName = "/WEB-INF/51Degrees.xml";
        }
        File configFile = new File(configFileName);
        PipelineBuilder builder = (PipelineBuilder)new PipelineBuilder().addService((PipelineService)new DataUpdateServiceDefault(LoggerFactory.getLogger((String)DataUpdateService.class.getSimpleName()), (HttpClient)new HttpClientDefault()));
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PipelineOptions.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PipelineOptions options = (PipelineOptions)unmarshaller.unmarshal(configFile);
            this.pipeline = StartupHelpers.buildFromConfiguration((PipelineBuilder)builder, (PipelineOptions)options, (boolean)config.getClientsidePropertiesEnabled());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        resultService.setPipeline(this.pipeline);
        clientsidePropertyService.setPipeline(this.pipeline);
        fiftyOneJsService.enable(config.getClientsidePropertiesEnabled());
    }

    public static void enableClientsideProperties(ViewControllerRegistry viewControllerRegistry) {
        viewControllerRegistry.addViewController("/51Degrees.core.js");
        viewControllerRegistry.addViewController("/51Degrees.core.json");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.resultService.process(request);
        this.uachService.setResponseHeaders(request, response);
        if (!this.fiftyOneJsService.serveJS(request, response) && !this.fiftyOneJsService.serveJson(request, response)) {
            return super.preHandle(request, response, handler);
        }
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            this.flowDataProvider.getFlowData(request).close();
        }
        catch (Exception e) {
            throw new Exception("FlowData could not be disposed of.", e);
        }
    }

    public ClientsidePropertyService getClientsidePropertyService() {
        return this.clientsidePropertyService;
    }
}

