/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web;

import fiftyone.pipeline.core.configuration.PipelineOptions;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.core.flowelements.PipelineBuilder;
import fiftyone.pipeline.core.services.PipelineService;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.DataUpdateServiceDefault;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import fiftyone.pipeline.web.StartupHelpers;
import fiftyone.pipeline.web.services.ClientsidePropertyServiceCore;
import fiftyone.pipeline.web.services.FiftyOneJSServiceCore;
import fiftyone.pipeline.web.services.FlowDataProviderCore;
import fiftyone.pipeline.web.services.PipelineResultServiceCore;
import fiftyone.pipeline.web.services.WebRequestEvidenceServiceCore;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.slf4j.LoggerFactory;

public class PipelineFilter
implements Filter {
    private Pipeline pipeline;
    private WebRequestEvidenceServiceCore evidenceService;
    private PipelineResultServiceCore resultService;
    private FlowDataProviderCore flowDataProviderCore;
    private ClientsidePropertyServiceCore clientsidePropertyServiceCore;
    private FiftyOneJSServiceCore jsService;
    FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        String clientsideEnabledString;
        this.config = filterConfig;
        String configFileName = filterConfig.getInitParameter("config-file");
        if (configFileName == null || configFileName.isEmpty()) {
            configFileName = "/WEB-INF/51Degrees.xml";
        }
        boolean clientsideEnabled = (clientsideEnabledString = filterConfig.getInitParameter("clientside-properties-enabled")) == null ? true : Boolean.parseBoolean(clientsideEnabledString);
        ServletContext context = this.config.getServletContext();
        File configFile = new File(context.getRealPath(configFileName));
        PipelineBuilder builder = new PipelineBuilder().addService((PipelineService)new DataUpdateServiceDefault(LoggerFactory.getLogger((String)DataUpdateService.class.getSimpleName()), (HttpClient)new HttpClientDefault()));
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PipelineOptions.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PipelineOptions options = (PipelineOptions)unmarshaller.unmarshal(configFile);
            this.pipeline = StartupHelpers.buildFromConfiguration(builder, options, clientsideEnabled, context.getContextPath());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        this.evidenceService = new WebRequestEvidenceServiceCore.Default();
        this.resultService = new PipelineResultServiceCore.Default(this.evidenceService, this.pipeline);
        this.flowDataProviderCore = new FlowDataProviderCore.Default();
        this.clientsidePropertyServiceCore = new ClientsidePropertyServiceCore.Default(this.flowDataProviderCore, this.pipeline);
        this.jsService = new FiftyOneJSServiceCore.Default(this.clientsidePropertyServiceCore, clientsideEnabled);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.resultService.process((HttpServletRequest)request);
        if (!this.jsService.serveJS((HttpServletRequest)request, (HttpServletResponse)response) && !this.jsService.serveJson((HttpServletRequest)request, (HttpServletResponse)response)) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        try {
            this.pipeline.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

