/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.pipeline.web.services;

import fiftyone.pipeline.core.data.FlowData;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public interface WebRequestEvidenceServiceCore {
    public void addEvidenceFromRequest(FlowData var1, HttpServletRequest var2);

    public static class Default
    implements WebRequestEvidenceServiceCore {
        @Override
        public void addEvidenceFromRequest(FlowData flowData, HttpServletRequest request) {
            HttpSession session;
            Enumeration enumeration;
            Cookie[] cookies;
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    String string = request.getHeader(headerName);
                    String evidenceKey = "header." + headerName;
                    this.checkAndAdd(flowData, evidenceKey, string);
                }
            }
            if ((cookies = request.getCookies()) != null) {
                for (Cookie cookie : cookies) {
                    String evidenceKey = "cookie." + cookie.getName();
                    this.checkAndAdd(flowData, evidenceKey, cookie.getValue());
                }
            }
            if ((enumeration = request.getParameterNames()) != null) {
                while (enumeration.hasMoreElements()) {
                    String parameterName = (String)enumeration.nextElement();
                    String evidenceKey = "query." + parameterName;
                    this.checkAndAdd(flowData, evidenceKey, request.getParameter(parameterName));
                }
            }
            if ((session = request.getSession()) != null) {
                this.checkAndAdd(flowData, "session", session);
                Enumeration sessionNames = session.getAttributeNames();
                while (sessionNames.hasMoreElements()) {
                    String sessionName = (String)sessionNames.nextElement();
                    String sessionKey = "session." + sessionName;
                    this.checkAndAdd(flowData, sessionKey, session.getAttribute(sessionName));
                }
            }
            this.checkAndAdd(flowData, "server.client-ip", request.getLocalAddr());
            this.checkAndAdd(flowData, "header.protocol", request.getScheme());
        }

        protected void checkAndAdd(FlowData flowData, String key, Object value) {
            if (flowData.getEvidenceKeyFilter().include(key)) {
                flowData.addEvidence(key, value);
            }
        }
    }
}

