package com.aallam.openai.api.chat;

import com.aallam.openai.api.BetaOpenAI
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * A completion generated by OpenAI.
 *
 * [documentation](https://platform.openai.com/docs/api-reference/chat/create)
 */
@BetaOpenAI
@Serializable
public data class ChatChoice(
    /**
     * Chat choice index.
     */
    @SerialName("index") public val index: Int? = null,
    /**
     * The generated chat message.
     */
    @SerialName("message") public val message: ChatMessage? = null,

    /**
     * The reason why OpenAI stopped generating.
     */
    @SerialName("finish_reason") public val finishReason: String? = null,
)
