/*
 * Decompiled with CFR 0.152.
 */
package com.aaronicsubstances.code.augmentor.ant;

import com.aaronicsubstances.code.augmentor.ant.TaskUtils;
import com.aaronicsubstances.code.augmentor.core.tasks.CompleteGenericTask;
import com.aaronicsubstances.code.augmentor.core.tasks.GenericTaskException;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CompletionTask
extends Task {
    private boolean verbose;
    private File genCodeFile;
    private File prepFile;
    private File destDir;
    private boolean codeChangeDetectionDisabled;
    private boolean failOnChanges = true;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setGenCodeFile(File genCodeFile) {
        this.genCodeFile = genCodeFile;
    }

    public void setPrepFile(File prepFile) {
        this.prepFile = prepFile;
    }

    public void setCodeChangeDetectionDisabled(boolean codeChangeDetectionDisabled) {
        this.codeChangeDetectionDisabled = codeChangeDetectionDisabled;
    }

    public void setFailOnChanges(boolean failOnChanges) {
        this.failOnChanges = failOnChanges;
    }

    public void execute() {
        try {
            CompletionTask.completeExecute(this, this.verbose, this.prepFile, this.genCodeFile, this.destDir, this.codeChangeDetectionDisabled, this.failOnChanges);
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BuildException("General error: " + ex, ex);
        }
    }

    static void completeExecute(Task task, boolean resolvedVerbose, File resolvedPrepFile, File resolvedGenCodeFile, File resolvedDestDir, boolean resolvedCodeChangeDetectionDisabled, boolean resolvedFailOnChanges) throws Exception {
        if (resolvedPrepFile == null) {
            resolvedPrepFile = TaskUtils.getDefaultPrepFile(task);
        }
        if (resolvedGenCodeFile == null) {
            resolvedGenCodeFile = TaskUtils.getDefaultGenCodeFile(task);
        }
        if (resolvedDestDir == null) {
            resolvedDestDir = TaskUtils.getDefaultDestDir(task);
        }
        CompleteGenericTask genericTask = new CompleteGenericTask();
        genericTask.setLogAppender(TaskUtils.createLogAppender(task, resolvedVerbose));
        genericTask.setGenCodeFile(resolvedGenCodeFile);
        genericTask.setPrepFile(resolvedPrepFile);
        genericTask.setDestDir(resolvedDestDir);
        genericTask.setCodeChangeDetectionDisabled(resolvedCodeChangeDetectionDisabled);
        if (resolvedVerbose) {
            task.log("Configuration properties:");
            task.log("\tdestDir: " + genericTask.getDestDir());
            task.log("\tgenCodeFile: " + genericTask.getGenCodeFile());
            task.log("\tprepFile: " + genericTask.getPrepFile());
            task.log("\tcodeChangeDetectionDisabled: " + genericTask.isCodeChangeDetectionDisabled());
            task.log("\tfailOnChanges: " + resolvedFailOnChanges);
            task.log("\tgenericTask.logAppender: " + genericTask.getLogAppender());
        }
        try {
            genericTask.execute();
        }
        catch (GenericTaskException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
        if (!genericTask.getAllErrors().isEmpty()) {
            String aggExMsg = genericTask.getAllErrors().size() + " error(s) found";
            BuildException aggException = new BuildException(aggExMsg);
            genericTask.getAllErrors().forEach(aggException::addSuppressed);
            throw aggException;
        }
        if (resolvedFailOnChanges && genericTask.isCodeChangeDetected()) {
            StringBuilder outOfSyncMsg = new StringBuilder();
            outOfSyncMsg.append("Some source file are now out of sync with generating code scripts. ");
            outOfSyncMsg.append("For details please look into top-level files of directory ");
            outOfSyncMsg.append(resolvedDestDir).append("\n");
            throw new BuildException(outOfSyncMsg.toString());
        }
    }
}

