/*
 * Decompiled with CFR 0.152.
 */
package com.aaronicsubstances.code.augmentor.ant;

import com.aaronicsubstances.code.augmentor.ant.DirectiveMarker;
import com.aaronicsubstances.code.augmentor.ant.TaskUtils;
import com.aaronicsubstances.code.augmentor.core.tasks.GenericTaskException;
import com.aaronicsubstances.code.augmentor.core.tasks.PrepareGenericTask;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class PrepareTask
extends Task {
    private String encoding;
    private boolean verbose;
    private File augCodeFile;
    private File prepFile;
    private final List<FileSet> srcDirs = new ArrayList<FileSet>();
    private final List<String> genCodeStartMarkers = new ArrayList<String>();
    private final List<String> genCodeEndMarkers = new ArrayList<String>();
    private final List<String> embeddedStringMarkers = new ArrayList<String>();
    private final List<String> embeddedJsonMarkers = new ArrayList<String>();
    private final List<String> skipCodeStartMarkers = new ArrayList<String>();
    private final List<String> skipCodeEndMarkers = new ArrayList<String>();
    private final List<String> inlineGenCodeMarkers = new ArrayList<String>();
    private final List<String> augCodeMarkers = new ArrayList<String>();
    private final List<String> nestedLevelStartMarkers = new ArrayList<String>();
    private final List<String> nestedLevelEndMarkers = new ArrayList<String>();

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setAugCodeFile(File augCodeFile) {
        this.augCodeFile = augCodeFile;
    }

    public void setPrepFile(File prepFile) {
        this.prepFile = prepFile;
    }

    public void addSrcDir(FileSet f) {
        this.srcDirs.add(f);
    }

    public void addConfiguredGenCodeStartMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.genCodeStartMarkers.add(val);
    }

    public void addConfiguredGenCodeEndMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.genCodeEndMarkers.add(val);
    }

    public void addConfiguredEmbeddedStringMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.embeddedStringMarkers.add(val);
    }

    public void addConfiguredEmbeddedJsonMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.embeddedJsonMarkers.add(val);
    }

    public void addConfiguredSkipCodeStartMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.skipCodeStartMarkers.add(val);
    }

    public void addConfiguredSkipCodeEndMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.skipCodeEndMarkers.add(val);
    }

    public void addConfiguredInlineGenCodeMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.inlineGenCodeMarkers.add(val);
    }

    public void addConfiguredAugCodeMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.augCodeMarkers.add(val);
    }

    public void addConfiguredNestedLevelStartMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.nestedLevelStartMarkers.add(val);
    }

    public void addConfiguredNestedLevelEndMarker(DirectiveMarker m) {
        String val = null;
        if (m.getValue() != null) {
            val = m.getValue();
        }
        this.nestedLevelEndMarkers.add(val);
    }

    public void execute() {
        try {
            PrepareTask.completeExecute(this, this.encoding, this.verbose, this.srcDirs, this.augCodeFile, this.prepFile, this.genCodeStartMarkers, this.genCodeEndMarkers, this.embeddedStringMarkers, this.embeddedJsonMarkers, this.skipCodeStartMarkers, this.skipCodeEndMarkers, this.inlineGenCodeMarkers, this.augCodeMarkers, this.nestedLevelStartMarkers, this.nestedLevelEndMarkers);
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BuildException("General error: " + ex, ex);
        }
    }

    static void completeExecute(Task task, String resolvedEncoding, boolean resolvedVerbose, List<FileSet> resolvedFileSets, File resolvedAugCodeFile, File resolvedPrepFile, List<String> resolvedGenCodeStartMarkers, List<String> resolvedGenCodeEndMarkers, List<String> resolvedEmbeddedStringMarkers, List<String> resolvedEmbeddedJsonMarkers, List<String> resolvedSkipCodeStartMarkers, List<String> resolvedSkipCodeEndMarkers, List<String> resolvedInlineGenCodeMarkers, List<String> resolvedAugCodeMarkers, List<String> resolvedNestedLevelStartMarkers, List<String> resolvedNestedLevelEndMarkers) throws Exception {
        if (resolvedEncoding == null) {
            resolvedEncoding = "UTF-8";
        }
        if (resolvedGenCodeStartMarkers.isEmpty()) {
            resolvedGenCodeStartMarkers.add("//:GEN_CODE_START:");
        }
        if (resolvedGenCodeEndMarkers.isEmpty()) {
            resolvedGenCodeEndMarkers.add("//:GEN_CODE_END:");
        }
        if (resolvedEmbeddedStringMarkers.isEmpty()) {
            resolvedEmbeddedStringMarkers.add("//:STR:");
        }
        if (resolvedEmbeddedJsonMarkers.isEmpty()) {
            resolvedEmbeddedJsonMarkers.add("//:JSON:");
        }
        if (resolvedSkipCodeStartMarkers.isEmpty()) {
            resolvedSkipCodeStartMarkers.add("//:SKIP_CODE_START:");
        }
        if (resolvedSkipCodeEndMarkers.isEmpty()) {
            resolvedSkipCodeEndMarkers.add("//:SKIP_CODE_END:");
        }
        if (resolvedInlineGenCodeMarkers.isEmpty()) {
            resolvedInlineGenCodeMarkers.add("/*:GEN_CODE:*/");
        }
        if (resolvedAugCodeMarkers.isEmpty()) {
            resolvedAugCodeMarkers.add("//:AUG_CODE:");
        }
        if (resolvedNestedLevelStartMarkers.isEmpty()) {
            resolvedNestedLevelStartMarkers.add("//:AUG_CODE_START:");
        }
        if (resolvedNestedLevelEndMarkers.isEmpty()) {
            resolvedNestedLevelEndMarkers.add("//:AUG_CODE_END:");
        }
        if (resolvedAugCodeFile == null) {
            resolvedAugCodeFile = TaskUtils.getDefaultAugCodeFile(task);
        }
        if (resolvedPrepFile == null) {
            resolvedPrepFile = TaskUtils.getDefaultPrepFile(task);
        }
        if (resolvedFileSets.isEmpty()) {
            throw new BuildException("at least 1 element is required in srcDirs");
        }
        for (int i = 0; i < resolvedFileSets.size(); ++i) {
            if (resolvedFileSets.get(i) != null) continue;
            throw new BuildException("invalid null value found at fileSets[" + i + "]");
        }
        Charset charset = Charset.forName(resolvedEncoding);
        ArrayList<String> allMarkers = new ArrayList<String>();
        PrepareTask.addAllIfEnabled(allMarkers, resolvedGenCodeStartMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedGenCodeEndMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedEmbeddedStringMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedEmbeddedJsonMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedSkipCodeStartMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedSkipCodeEndMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedInlineGenCodeMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedAugCodeMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedNestedLevelStartMarkers);
        PrepareTask.addAllIfEnabled(allMarkers, resolvedNestedLevelEndMarkers);
        if (allMarkers.stream().anyMatch(x -> x == null || x.trim().isEmpty())) {
            throw new BuildException("nulls/blanks detected across markers");
        }
        if ((long)allMarkers.size() != allMarkers.stream().distinct().count()) {
            throw new BuildException("duplicates detected across markers");
        }
        ArrayList<File> baseDirs = new ArrayList<File>();
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (FileSet srcDir : resolvedFileSets) {
            String[] includedFiles;
            DirectoryScanner ds = srcDir.getDirectoryScanner(task.getProject());
            for (String filename : includedFiles = ds.getIncludedFiles()) {
                baseDirs.add(ds.getBasedir());
                assert (!filename.startsWith("/"));
                assert (!filename.startsWith("\\"));
                relativePaths.add(filename);
            }
        }
        if (relativePaths.isEmpty()) {
            task.log("No files were found", 1);
        } else {
            task.log(String.format("Found %s file(s)", relativePaths.size()));
        }
        PrepareGenericTask genericTask = new PrepareGenericTask();
        genericTask.setCharset(charset);
        genericTask.setLogAppender(TaskUtils.createLogAppender(task, resolvedVerbose));
        genericTask.setAugCodeFile(resolvedAugCodeFile);
        genericTask.setPrepFile(resolvedPrepFile);
        genericTask.setRelativePaths(relativePaths);
        genericTask.setBaseDirs(baseDirs);
        genericTask.setGenCodeStartMarkers(resolvedGenCodeStartMarkers);
        genericTask.setGenCodeEndMarkers(resolvedGenCodeEndMarkers);
        genericTask.setEmbeddedStringMarkers(resolvedEmbeddedStringMarkers);
        genericTask.setEmbeddedJsonMarkers(resolvedEmbeddedJsonMarkers);
        genericTask.setSkipCodeStartMarkers(resolvedSkipCodeStartMarkers);
        genericTask.setSkipCodeEndMarkers(resolvedSkipCodeEndMarkers);
        genericTask.setInlineGenCodeMarkers(resolvedInlineGenCodeMarkers);
        genericTask.setAugCodeMarkers(resolvedAugCodeMarkers);
        genericTask.setNestedLevelStartMarkers(resolvedNestedLevelStartMarkers);
        genericTask.setNestedLevelEndMarkers(resolvedNestedLevelEndMarkers);
        if (resolvedVerbose) {
            task.log("Configuration properties:");
            task.log("\tencoding: " + genericTask.getCharset());
            task.log("\tgenCodeStartMarkers: " + genericTask.getGenCodeStartMarkers());
            task.log("\tgenCodeEndMarkers: " + genericTask.getGenCodeEndMarkers());
            task.log("\tembeddedStringMarkers: " + genericTask.getEmbeddedStringMarkers());
            task.log("\tembeddedJsonMarkers: " + genericTask.getEmbeddedJsonMarkers());
            task.log("\tskipCodeStartMarkers: " + genericTask.getSkipCodeStartMarkers());
            task.log("\tskipCodeEndMarkers: " + genericTask.getSkipCodeEndMarkers());
            task.log("\tinlineGenCodeMarkers: " + genericTask.getInlineGenCodeMarkers());
            task.log("\taugCodeMarkers: " + genericTask.getAugCodeMarkers());
            task.log("\tnestedLevelStartMarkers: " + genericTask.getNestedLevelStartMarkers());
            task.log("\tnestedLevelEndMarkers: " + genericTask.getNestedLevelEndMarkers());
            task.log("\taugCodeFile: " + genericTask.getAugCodeFile());
            task.log("\tprepFile: " + genericTask.getPrepFile());
            task.log("\tgenericTask.logAppender: " + genericTask.getLogAppender());
            task.log("\tgenericTask.baseDirs: " + new HashSet(genericTask.getBaseDirs()));
            task.log("\tsrcDirs: " + resolvedFileSets);
        }
        try {
            genericTask.execute();
        }
        catch (GenericTaskException ex) {
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
        if (!genericTask.getAllErrors().isEmpty()) {
            String aggExMsg = genericTask.getAllErrors().size() + " error(s) found";
            BuildException aggException = new BuildException(aggExMsg);
            genericTask.getAllErrors().forEach(aggException::addSuppressed);
            throw aggException;
        }
    }

    private static void addAllIfEnabled(List<String> allMarkers, List<String> particularMarkers) {
        String loneMarker;
        if (particularMarkers.size() == 1 && ((loneMarker = particularMarkers.get(0)) == null || loneMarker.trim().isEmpty())) {
            return;
        }
        allMarkers.addAll(particularMarkers);
    }
}

