/*
 * Decompiled with CFR 0.152.
 */
package com.aaronicsubstances.code.augmentor.ant;

import com.aaronicsubstances.code.augmentor.core.tasks.GenericTaskLogLevel;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.tools.ant.Task;

public class TaskUtils {
    public static BiConsumer<GenericTaskLogLevel, Supplier<String>> createLogAppender(Task task, boolean verboseEnabled) {
        BiConsumer<GenericTaskLogLevel, Supplier<String>> logAppender = (logLevel, msgFunc) -> {
            switch (logLevel) {
                case VERBOSE: {
                    if (!verboseEnabled) break;
                }
                case INFO: {
                    task.log((String)msgFunc.get());
                    break;
                }
                case WARN: {
                    task.log((String)msgFunc.get(), 1);
                }
            }
        };
        return logAppender;
    }

    public static File getDefaultBuildDir(Task task) {
        File defaultBuildDir = new File(new File(task.getProject().getBaseDir(), "build"), "codeAugmentor");
        return defaultBuildDir;
    }

    public static File getDefaultPrepFile(Task task) {
        return new File(TaskUtils.getDefaultBuildDir(task), "parseResults.json");
    }

    public static File getDefaultAugCodeFile(Task task) {
        return new File(TaskUtils.getDefaultBuildDir(task), "augCodes.json");
    }

    public static File getDefaultGenCodeFile(Task task) {
        return new File(TaskUtils.getDefaultBuildDir(task), "genCodes.json");
    }

    public static File getDefaultDestDir(Task task) {
        return new File(TaskUtils.getDefaultBuildDir(task), "generated");
    }
}

