/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.adapter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

public class PluginConstraintsJsonAdapter extends JsonSerializer<Map<String, String>>
{

    @Override
    public void serialize(final Map<String, String> value, final JsonGenerator jgen,
        final SerializerProvider provider) throws IOException, JsonProcessingException
    {
        Map<String, String> newMap = new HashMap<>();
        for (Map.Entry<String, String> entry : value.entrySet())
        {
            newMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        jgen.writeObject(newMap);
    }

}
