/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

import java.io.Serializable;

public enum ComponentType implements Serializable
{
    UNKNOWN("Unknown component"),
    // Platform is the root of the hierarchy
    PLATFORM("Abicloud Platform"),

    // Datacenter is the root of the physical infrastructure tree
    DATACENTER("Physical Datacenter"), RACK("Logical Rack for physical servers"), MACHINE(
        "Physical server in the compute cloud"), VIRTUAL_STORAGE("Virtual Storage System"), STORAGE_POOL(
        "Storage Pool of Volumes"),

    // Enterprise is the root of the logical infrastructure tree
    ENTERPRISE("Organization"), USER("Platform user"), VIRTUAL_DATACENTER("Virtual Datacenter"), VIRTUAL_APPLIANCE(
        "Virtual Appliances Architecture"),

    // VirtualMachine, Volume and Network are shared between logical and physical infrastructure
    VIRTUAL_MACHINE("Virtual Server"), VOLUME("Storage Volume"), NETWORK("IP Network"),

    // Appliance manager
    APPLIANCE_MANAGER("Appliance Manager"),

    // Image converter
    IMAGE_CONVERTER("Image converter"),

    // License management
    LICENSE_MANAGER("License Manager"),

    // Stateful converter
    PERSISTENT_CONVERTER("Persistent converter"),

    // Abiquo's API
    API("API"),

    // Workload Engine
    WORKLOAD("Workload Engine"),

    // Roles
    ROLE("Role"),

    // Roles
    ROLE_LDAP("Role LDAP"),

    // Scopes
    SCOPE("Scope"),

    // HA
    HIGH_AVAILABILITY("High availability engine"),

    // PRICING_ TEMPLATE
    PRICING_TEMPLATE("Pricing Template"),

    // COSTCODE_CURRENCY
    COSTCODE_CURRENCY("Cost Code - Currency"),

    // COSTCODE
    COSTCODE("Cost Code"),

    // STORAGE DEVICES
    STORAGE_DEVICE("Storage device"),

    // INSTANCE_CONVERTER
    INSTANCE_CONVERTER("Instance converter");

    private final String description;

    private ComponentType(final String description)
    {
        this.description = description;
    }

    public String getDescription()
    {
        return description;
    }
}
