/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

public enum MachineState
{
    STOPPED, PROVISIONED, NOT_MANAGED, MANAGED, HALTED, UNLICENSED, HA_IN_PROGRESS, DISABLED_FOR_HA, HALTED_FOR_SAVE;

    public boolean isRetrieveAllowed()
    {
        if (this.isBeingProcessedByHA())
        {
            return false;
        }

        switch (this)
        {
            case MANAGED:
            case HALTED:
                // ABICLOUDPREMIUM-4551: we are allowing to retrieve machines in HALTED (disabled by
                // user request)
                return true;
            default:
                return false;
        }
    }

    public boolean isBeingProcessedByHA()
    {
        switch (this)
        {
            case HA_IN_PROGRESS:
            case DISABLED_FOR_HA:
                return true;
            default:
                return false;
        }
    }
}
