/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

/**
 * Existing privileges in the platform
 * 
 * @author dlopez
 */
public enum Privileges
{
    AUTHENTICATED,

    // APPS LIBRARY
    APPLIB_ALLOW_MODIFY, APPLIB_DOWNLOAD_IMAGE, APPLIB_MANAGE_CATEGORIES, APPLIB_MANAGE_GLOBAL_CATEGORIES, APPLIB_MANAGE_REPOSITORY, APPLIB_SHOW_DC_CAPACITY, APPLIB_UPLOAD_IMAGE, APPLIB_VIEW, APPLIB_VM_COST_CODE,

    // ENTERPRISE
    ENTERPRISE_ADMINISTER_ALL, ENTERPRISE_ENUMERATE, ENTERPRISE_RESOURCE_SUMMARY_ENT, ENTERPRISE_SHOW_STATS_LIMITS,

    // EVENTS
    EVENTLOG_VIEW_ALL, EVENTLOG_VIEW_ENTERPRISE,

    // FIREWALLS
    ASSIGN_FIREWALLS, MANAGE_FIREWALLS,

    // LOADBALANCER
    ASSIGN_LOADBALANCERS, MANAGE_LOADBALANCERS,

    // FLOATING IPS
    MANAGE_FLOATINGIPS,

    // HARD DISKS
    MANAGE_HARD_DISKS,

    // INFRASTRUCTURE
    PHYS_DC_ALLOW_BACKUP_CONFIG, PHYS_DC_ALLOW_MODIFY_ALLOCATION, PHYS_DC_ALLOW_MODIFY_NETWORK, PHYS_DC_ALLOW_MODIFY_SERVERS, PHYS_DC_ALLOW_MODIFY_STORAGE, PHYS_DC_ENUMERATE, PHYS_DC_MANAGE, PHYS_DC_RETRIEVE_DETAILS, PHYS_DC_RETRIEVE_RESOURCE_USAGE,

    // PRICING
    PRICING_MANAGE, PRICING_VIEW,

    // SYSTEM CONFIG
    SYSCONFIG_ALLOW_MODIFY, SYSCONFIG_SHOW_REPORTS, SYSCONFIG_VIEW,

    // USERS
    USERS_DEFINE_AS_MANAGER, USERS_ENABLE_DISABLE_VM_METRICS, USERS_ENUMERATE_CONNECTED, USERS_MANAGE_CHEF_ENTERPRISE, USERS_MANAGE_ENTERPRISE, USERS_MANAGE_ENTERPRISE_BRANDING, USERS_MANAGE_LDAP_GROUP, USERS_MANAGE_OTHER_ENTERPRISES, USERS_MANAGE_RESERVED_MACHINES, USERS_MANAGE_ROLES, USERS_MANAGE_ROLES_OTHER_ENTERPRISES, USERS_MANAGE_SCOPES, USERS_MANAGE_SYSTEM_ROLES, USERS_MANAGE_USERS, USERS_PROHIBIT_VDC_RESTRICTION, USERS_SHOW_VM_METRICS, USERS_VIEW, USERS_VIEW_PRIVILEGES,

    // VIRTUAL APPLIANCE
    VAPP_CREATE_INSTANCE, VAPP_CREATE_STATEFUL, VAPP_CUSTOMISE_SETTINGS, VAPP_DEFINE_BACKUP_INFO, VAPP_DELETE_UNKNOWN_VM, VAPP_DEPLOY_UNDEPLOY, VAPP_MANAGE_BACKUP, VAPP_MANAGE_BACKUP_DISKS, VAPP_MANAGE_LAYERS, VAPP_PERFORM_ACTIONS, VAPP_STATEFUL_VIEW,

    // VIRTUAL VIRTUALDATACENTER
    VDC_ENUMERATE, VDC_MANAGE, VDC_MANAGE_NETWORK, VDC_MANAGE_STORAGE, VDC_MANAGE_VAPP,

    // WORKFLOW
    WORKFLOW_OVERRIDE;

    public static Privileges[] simpleRole()
    {
        Privileges[] p =
            {VDC_ENUMERATE, VDC_MANAGE_VAPP, VAPP_CUSTOMISE_SETTINGS, VAPP_DEPLOY_UNDEPLOY,
            VAPP_PERFORM_ACTIONS, VAPP_CREATE_INSTANCE, VAPP_CREATE_STATEFUL,
            EVENTLOG_VIEW_ENTERPRISE};
        return p;
    }
}
