/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

/**
 * The storage allocation police.
 * 
 * @author Ignasi Barrera
 */
public enum StorageAllocationPolicy
{
    /** If this policy is set, the volumes will be created in the pool with more space available. */
    PERFORMANCE,

    /**
     * If this policy is set, the volumes will be created in the pool with less space. Volumes will
     * be created in one pool until it is empty, then they will be created in the enxt pool.
     */
    PROGRESSIVE;
}
