/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

import javax.xml.bind.annotation.XmlEnum;

import com.abiquo.server.core.task.TaskState;

/**
 * Indicates the state of the virtual machine templates (normal, instance and persistent template)
 * 
 * @author Sergi Castro
 */
@XmlEnum
public enum VMTemplateState
{
    IN_PROGRESS, DONE, FAILED, UNAVAILABLE;

    public static VMTemplateState fromTask(final TaskState state)
    {
        if (state == null)
        {
            // NOTE: Persistent template create before 2.2 version will not have any task but
            // they were finished succesfully
            return VMTemplateState.DONE;
        }
        switch (state)
        {
            case STARTED:
            case PENDING:
                return VMTemplateState.IN_PROGRESS;
            case FINISHED_SUCCESSFULLY:
                return VMTemplateState.DONE;
            case FINISHED_UNSUCCESSFULLY:
            case ABORTED:
                return VMTemplateState.FAILED;
            default:
                return null;
        }
    }
}
