/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.enumerator;

/**
 * The volume state.
 * <p>
 * <b>IMPORTANT:</b> Do not change the order of the elements of the enum. If more values need to be
 * added they must be added at the end.
 * 
 * @author abiquo
 */
public enum VolumeState
{
    /** The volume is not attached to a virtual machine. */
    DETACHED,

    /** The volume is attached to a virtual machine. */
    ATTACHED
}
