/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.rest;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * extension to use the link fields as attributes in the Xml
 * 
 * @author dcalavera
 */
@XmlRootElement(name = "link")
public class RESTLink
{
    @XmlAttribute
    private String length;

    @XmlAttribute
    private String title;

    @XmlAttribute
    private String hreflang;

    @XmlAttribute
    private String rel;

    @XmlAttribute
    private String type;

    @XmlAttribute
    private String href;

    public RESTLink()
    {

    }

    public RESTLink(final String rel, final String href)
    {
        this.rel = rel;
        this.href = href;
    }

    @XmlTransient
    public String getLength()
    {
        return length;
    }

    public void setLength(final String length)
    {
        this.length = length;
    }

    @XmlTransient
    public String getTitle()
    {
        return title;
    }

    public void setTitle(final String title)
    {
        this.title = title;
    }

    @XmlTransient
    public String getHreflang()
    {
        return hreflang;
    }

    public void setHreflang(final String hreflang)
    {
        this.hreflang = hreflang;
    }

    @XmlTransient
    public String getRel()
    {
        return rel;
    }

    public void setRel(final String rel)
    {
        this.rel = rel;
    }

    @XmlTransient
    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    @XmlTransient
    public String getHref()
    {
        return href;
    }

    public void setHref(final String href)
    {
        this.href = href;
    }

    @XmlTransient
    @JsonIgnore
    public Integer getId()
    {
        // Maybe URIs don't have a trailing slash
        String id =
            href.substring(href.lastIndexOf("/") + 1,
                href.endsWith("/") ? href.length() - 1 : href.length());
        try
        {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e)
        {
            return null;
        }
    }

    @Override
    public String toString()
    {
        StringBuilder sb = new StringBuilder();
        sb.append("<link");
        if (rel != null && !rel.isEmpty())
        {
            sb.append(" rel=\"" + rel + "\"");
        }
        if (title != null && !title.isEmpty())
        {
            sb.append(" title=\"" + title + "\"");
        }
        if (type != null && !type.isEmpty())
        {
            sb.append(" type=\"" + type + "\"");
        }
        if (hreflang != null && !hreflang.isEmpty())
        {
            sb.append(" hreflang=\"" + hreflang + "\"");
        }
        if (href != null && !href.isEmpty())
        {
            sb.append(" href=\"" + href + "\"");
        }
        return sb.append("/>").toString();
    }
}
