/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.rest.RESTLink;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * This Entity is the response of 202. It is a list of links (most of the cases one) and an optional
 * Object (most of the cases the string with the message to response).
 * 
 * @author ssedano
 */
@XmlRootElement(name = "acceptedrequest")
@XmlType(propOrder = {"entity"})
public class AcceptedRequestDto<T> extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -7743440222172054557L;

    private static final String TYPE = "application/vnd.abiquo.acceptedrequest";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_XML_22 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_23;

    private static final String STATUS_REL = "status";

    private T entity;

    /**
     * The returning entity. Normally a message.
     * 
     * @return entity.
     */
    @XmlElement(name = "message", namespace = "", nillable = true, required = false)
    public T getEntity()
    {
        return entity;
    }

    public void setEntity(final T entity)
    {
        this.entity = entity;
    }

    public void setStatusUrlLink(final String url)
    {
        addLink(new RESTLink(STATUS_REL, url));
    }

    /**
     * The status link where you can track the status of the request.
     * 
     * @return link.
     */
    @JsonIgnore
    public RESTLink getStatusLink()
    {
        return searchLink(STATUS_REL);
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
