/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport;

import com.abiquo.model.rest.RESTLink;

/**
 * Representation of a moved permanently response.
 * 
 * @author sacedo
 */
// IMPORTANT: To avoid unmarshalling issues this class should be kept abstract and add a concrete
// implementation for each concrete entity that supports move operations
// Also, to avoid unmarshalling issues, ALL JAXB ANNOTATIONS should be set only in the concrete
// subclasses
public abstract class MovedPermanentlyDto
{
    /** The link to the new location of the moved resource. */
    private RESTLink location;

    public RESTLink getLocation()
    {
        return location;
    }

    public void setLocation(final RESTLink locationLink)
    {
        this.location = locationLink;
    }

}
