/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport;

import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder = {"repositoryHardInMb", "repositorySoftInMb", "repositoryHard",
"repositorySoft"})
public abstract class SingleResourceWithAllLimitsDto extends SingleResourceWithLimitsDto
{
    private static final long serialVersionUID = 1L;

    private Long repositorySoftInMb;

    private Long repositoryHardInMb;

    @Deprecated
    private Long repositorySoft;

    @Deprecated
    private Long repositoryHard;

    /**
     * Soft limit stablished for repository size
     */
    public Long getRepositorySoftInMb()
    {
        return repositorySoftInMb;
    }

    public void setRepositorySoftInMb(final Long repositorySoftInMb)
    {
        this.repositorySoftInMb = repositorySoftInMb;
    }

    /**
     * Hard limit established for repository size
     */
    public Long getRepositoryHardInMb()
    {
        return repositoryHardInMb;
    }

    public void setRepositoryHardInMb(final Long repositoryHardInMb)
    {
        this.repositoryHardInMb = repositoryHardInMb;
    }

    @Deprecated
    public Long getRepositorySoft()
    {
        return repositorySoft;
    }

    @Deprecated
    public void setRepositorySoft(final Long repositorySoft)
    {
        this.repositorySoft = repositorySoft;
    }

    @Deprecated
    public Long getRepositoryHard()
    {
        return repositoryHard;
    }

    @Deprecated
    public void setRepositoryHard(final Long repositoryHard)
    {
        this.repositoryHard = repositoryHard;
    }

    public void setRepositoryLimitsInMb(final long soft, final long hard)
    {
        this.repositorySoftInMb = soft;
        this.repositoryHardInMb = hard;
    }

    @Deprecated
    public void setRepositoryLimits(final long soft, final long hard)
    {
        this.repositorySoft = soft;
        this.repositoryHard = hard;
    }

}
