/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder = {"cpuCountHardLimit", "cpuCountSoftLimit", "ramHardLimitInMb",
"ramSoftLimitInMb", "diskHardLimitInMb", "diskSoftLimitInMb", "storageHardInMb", "storageSoftInMb",
"hdHardLimitInMb", "hdSoftLimitInMb", "storageHard", "storageSoft", "vlansHard", "vlansSoft",
"publicIpsHard", "publicIpsSoft"})
public abstract class SingleResourceWithLimitsDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private int ramSoftLimitInMb;

    private int ramHardLimitInMb;

    private int cpuCountSoftLimit;

    private int cpuCountHardLimit;

    private Long diskSoftLimitInMb;

    private Long diskHardLimitInMb;

    private Long storageSoftInMb;

    private Long storageHardInMb;

    @Deprecated
    private Long hdSoftLimitInMb;

    @Deprecated
    private Long hdHardLimitInMb;

    @Deprecated
    private Long storageSoft;

    @Deprecated
    private Long storageHard;

    private long vlansSoft;

    private long vlansHard;

    private long publicIpsSoft;

    private long publicIpsHard;

    /**
     * Total amount of RAM memory that may be used by Virtual Machines. Soft limit
     * 
     * @return Total amount of RAM memory that may be used by Virtual Machines. Soft limit
     */
    @XmlElement(name = "ramSoft")
    @NotNull
    public int getRamSoftLimitInMb()
    {
        return ramSoftLimitInMb;
    }

    public void setRamSoftLimitInMb(final int ramSoftLimitInMb)
    {
        this.ramSoftLimitInMb = ramSoftLimitInMb;
    }

    /**
     * Total amount of RAM memory that may be used by Virtual Machines. Hard limit
     * 
     * @returnTotal amount of RAM memory that may be used by Virtual Machines. Hard limit
     */
    @XmlElement(name = "ramHard")
    @NotNull
    public int getRamHardLimitInMb()
    {
        return ramHardLimitInMb;
    }

    public void setRamHardLimitInMb(final int ramHardLimitInMb)
    {
        this.ramHardLimitInMb = ramHardLimitInMb;
    }

    /**
     * Total amount of Virtual CPUs that may be used by Virtual Machines. Soft limit
     * 
     * @return Total amount of Virtual CPUs that may be used by Virtual Machines. Soft limit
     */
    @XmlElement(name = "cpuSoft")
    @NotNull
    public int getCpuCountSoftLimit()
    {
        return cpuCountSoftLimit;
    }

    public void setCpuCountSoftLimit(final int cpuCountSoftLimit)
    {
        this.cpuCountSoftLimit = cpuCountSoftLimit;
    }

    /**
     * Total amount of Virtual CPUs that may be used by Virtual Machines. Hard limit
     * 
     * @return Total amount of Virtual CPUs that may be used by Virtual Machines. Hard limit
     */
    @XmlElement(name = "cpuHard")
    @NotNull
    public int getCpuCountHardLimit()
    {
        return cpuCountHardLimit;
    }

    public void setCpuCountHardLimit(final int cpuCountHardLimit)
    {
        this.cpuCountHardLimit = cpuCountHardLimit;
    }

    /**
     * Total size of Hard Disks that may be used by Virtual Machines. Soft limit
     * 
     * @return Total size of Hard Disks that may be used by Virtual Machines. Soft limit
     */
    public Long getDiskSoftLimitInMb()
    {
        return diskSoftLimitInMb;
    }

    public void setDiskSoftLimitInMb(final Long diskSoftLimitInMb)
    {
        this.diskSoftLimitInMb = diskSoftLimitInMb;
    }

    /**
     * Total size of Hard Disks that may be used by Virtual Machines. Hard limit
     * 
     * @return Total size of Hard Disks that may be used by Virtual Machines. Hard limit
     */
    public Long getDiskHardLimitInMb()
    {
        return diskHardLimitInMb;
    }

    public void setDiskHardLimitInMb(final Long diskHardLimitInMb)
    {
        this.diskHardLimitInMb = diskHardLimitInMb;
    }

    /**
     * Total size of Hard Disks that may be used by Virtual Machines. Soft limit
     * 
     * @return Total size of Hard Disks that may be used by Virtual Machines. Soft limit
     */
    @XmlElement(name = "hdSoft")
    @Deprecated
    public Long getHdSoftLimitInMb()
    {
        return hdSoftLimitInMb;
    }

    @Deprecated
    public void setHdSoftLimitInMb(final Long hdSoftLimitInMb)
    {
        this.hdSoftLimitInMb = hdSoftLimitInMb;
    }

    /**
     * Total size of Hard Disks that may be used by Virtual Machines. Hard limit
     * 
     * @return Total size of Hard Disks that may be used by Virtual Machines. Hard limit
     */
    @XmlElement(name = "hdHard")
    @Deprecated
    public Long getHdHardLimitInMb()
    {
        return hdHardLimitInMb;
    }

    @Deprecated
    public void setHdHardLimitInMb(final Long hdHardLimitInMb)
    {
        this.hdHardLimitInMb = hdHardLimitInMb;
    }

    /**
     * Total size of external storage that may be assigned. Soft limit
     * 
     * @return Total size of external storage that may be assigned. Soft limit
     */
    @NotNull
    public Long getStorageSoftInMb()
    {
        return storageSoftInMb;
    }

    public void setStorageSoftInMb(final Long storageSoftInMb)
    {
        this.storageSoftInMb = storageSoftInMb;
    }

    /**
     * Total size of external storage that may be assigned. Hard limit
     * 
     * @return Total size of external storage that may be assigned. Hard limit
     */
    public Long getStorageHardInMb()
    {
        return storageHardInMb;
    }

    public void setStorageHardInMb(final Long storageHardInMb)
    {
        this.storageHardInMb = storageHardInMb;
    }

    /**
     * Total size of external storage that may be assigned. Soft limit
     * 
     * @return Total size of external storage that may be assigned. Soft limit
     */
    @Deprecated
    public Long getStorageSoft()
    {
        return storageSoft;
    }

    @Deprecated
    public void setStorageSoft(final Long storageSoft)
    {
        this.storageSoft = storageSoft;
    }

    /**
     * Total size of external storage that may be assigned. Hard limit
     * 
     * @return Total size of external storage that may be assigned. Hard limit
     */
    @Deprecated
    public Long getStorageHard()
    {
        return storageHard;
    }

    @Deprecated
    public void setStorageHard(final Long storageHard)
    {
        this.storageHard = storageHard;
    }

    /**
     * Total amount of VLANs that may be defined. Soft limit
     * 
     * @return Total amount of VLANs that may be defined. Soft limit
     */
    @NotNull
    public long getVlansSoft()
    {
        return vlansSoft;
    }

    public void setVlansSoft(final long vlansSoft)
    {
        this.vlansSoft = vlansSoft;
    }

    /**
     * Total amount of VLANs that may be defined. Hard limit
     * 
     * @return Total amount of VLANs that may be defined. Hard limit
     */
    @NotNull
    public long getVlansHard()
    {
        return vlansHard;
    }

    public void setVlansHard(final long vlansHard)
    {
        this.vlansHard = vlansHard;
    }

    /**
     * Total amount of Public IPs that may be defined. Soft limit
     * 
     * @return Total amount of Public IPs that may be defined. Soft limit
     */
    @NotNull
    public long getPublicIpsSoft()
    {
        return publicIpsSoft;
    }

    public void setPublicIpsSoft(final long publicIpsSoft)
    {
        this.publicIpsSoft = publicIpsSoft;
    }

    /**
     * Total amount of Public IPs that may be defined. Hard limit
     * 
     * @return Total amount of Public IPs that may be defined. Hard limit
     */
    @NotNull
    public long getPublicIpsHard()
    {
        return publicIpsHard;
    }

    public void setPublicIpsHard(final long publicIpsHard)
    {
        this.publicIpsHard = publicIpsHard;
    }

    public void setStorageLimitsInMb(final long softLimit, final long hardLimit)
    {
        setStorageSoftInMb(softLimit);
        setStorageHardInMb(hardLimit);
    }

    @Deprecated
    public void setStorageLimits(final long softLimit, final long hardLimit)
    {
        setStorageSoft(softLimit);
        setStorageHard(hardLimit);
    }

    public void setVlansLimits(final long softLimit, final long hardLimit)
    {
        setVlansSoft(softLimit);
        setVlansHard(hardLimit);
    }

    public void setPublicIPLimits(final long softLimit, final long hardLimit)
    {
        setPublicIpsSoft(softLimit);
        setPublicIpsHard(hardLimit);
    }

    public void setRamLimitsInMb(final int softLimit, final int hardLimit)
    {
        setRamSoftLimitInMb(softLimit);
        setRamHardLimitInMb(hardLimit);
    }

    public void setCpuCountLimits(final int softLimit, final int hardLimit)
    {
        setCpuCountSoftLimit(softLimit);
        setCpuCountHardLimit(hardLimit);
    }

    public void setDiskLimitsInMb(final long softLimit, final long hardLimit)
    {
        setDiskSoftLimitInMb(softLimit);
        setDiskHardLimitInMb(hardLimit);
    }

    @Deprecated
    public void setHdLimitsInMb(final long softLimit, final long hardLimit)
    {
        setHdSoftLimitInMb(softLimit);
        setHdHardLimitInMb(hardLimit);
    }
}
