/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class WrapperDto<T> extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    protected List<T> collection = new ArrayList<T>();

    private Integer totalSize;

    public void add(final T element)
    {
        collection.add(element);
    }

    public void addAll(final Collection<T> elements)
    {
        collection.addAll(elements);
    }

    public void addAll(final WrapperDto<T> errors)
    {
        collection.addAll(errors.getCollection());
    }

    public abstract List<T> getCollection();

    public Integer getTotalSize()
    {
        return totalSize;
    }

    @JsonIgnore
    public boolean isEmpty()
    {
        return collection.isEmpty();
    }

    public void setTotalSize(final Integer totalSize)
    {
        this.totalSize = totalSize;
    }
}
