/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport.error;

import java.util.ArrayList;
import java.util.List;

import com.abiquo.model.rest.RESTLink;

/**
 * Any exception of the API inside the service layer should have this object instead the
 * {@link ErrorDto} object, which is a REST object.
 * 
 * @author jdevesa@abiquo.com
 */
public class CommonError
{
    private String code;

    private String message;

    private String details;

    private Object culprit;

    private List<RESTLink> links = new ArrayList<RESTLink>();

    public CommonError(final String code, final String message)
    {
        this.code = code;
        this.message = message;
    }

    public CommonError(final String code, final String message, final Object culprit)
    {
        this.code = code;
        this.message = message;
        this.culprit = culprit;
    }

    public CommonError(final String code, final String message, final String details)
    {
        this.code = code;
        this.message = message;
        this.details = details;
    }

    public String getCode()
    {
        return code;
    }

    public String getMessage()
    {
        return message;
    }

    public String getDetails()
    {
        return details;
    }

    public Object getCulprit()
    {
        return culprit;
    }

    public List<RESTLink> getLinks()
    {
        return links;
    }

    public void setLinks(final List<RESTLink> links)
    {
        this.links = links;
    }
}
