/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport.error;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.WrapperDto;

/**
 * Represent a collection of errors
 */
@XmlRootElement(name = "errors")
public class ErrorsDto extends WrapperDto<ErrorDto>
{
    private static final long serialVersionUID = 1L;

    public static final String TYPE = "application/vnd.abiquo.error";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    @Override
    @XmlElement(name = "error")
    public List<ErrorDto> getCollection()
    {
        if (collection == null)
        {
            collection = new ArrayList<ErrorDto>();
        }
        return collection;
    }

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder("");
        for (ErrorDto error : getCollection())
        {
            builder.append(error.toString()).append("\n");
        }
        return builder.toString();
    }

    @Override
    public int hashCode()
    {
        return 31 * toString().hashCode();
    }

    public ErrorsDto()
    {
        super();
    }

    public ErrorsDto(final Set<CommonError> errors)
    {
        super();
        for (CommonError commonError : errors)
        {
            this.getCollection().add(new ErrorDto(commonError.getCode(), commonError.getMessage()));
        }
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
