/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.transport.error;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "limiterror")
@XmlType(propOrder = {"entityId", "entityName", "entityType", "hardLimit", "cpu", "ram", "hd",
"storage", "vlan", "ip", "repository"})
public class LimitExceededErrorDto extends ErrorDto
{

    public static enum TYPE
    {
        ENTERPRISE, VIRTUALDATACENTER, DATACENTERLIMITS
    }

    @XmlType(propOrder = {"required", "actual", "soft", "hard", "status"})
    public static class LimitStatus
    {
        public static enum Status
        {
            OK, SOFT, HARD
        }

        private long required;

        private long actual;

        private long soft;

        private long hard;

        private Status status;

        public LimitStatus()
        {

        }

        public LimitStatus(final long actual, final long required, final long soft,
            final long hard, final Status status)
        {
            this.actual = actual;
            this.required = required;
            this.soft = soft;
            this.hard = hard;
            this.status = status;
        }

        public long getActual()
        {
            return actual;
        }

        public void setActual(final long actual)
        {
            this.actual = actual;
        }

        public long getRequired()
        {
            return required;
        }

        public void setRequired(final long required)
        {
            this.required = required;
        }

        public long getSoft()
        {
            return soft;
        }

        public void setSoft(final long soft)
        {
            this.soft = soft;
        }

        public long getHard()
        {
            return hard;
        }

        public void setHard(final long hard)
        {
            this.hard = hard;
        }

        public Status getStatus()
        {
            return status;
        }

        public void setStatus(final Status status)
        {
            this.status = status;
        }
    }

    private static final long serialVersionUID = 3458319964444188081L;

    private static final String TYPE = "application/vnd.abiquo.limiterror";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private LimitStatus cpu;

    private LimitStatus ram;

    private LimitStatus hd;

    private LimitStatus storage;

    private LimitStatus vlan;

    private LimitStatus ip;

    private LimitStatus repository;

    private String entityName;

    private TYPE entityType;

    private Integer entityId;

    private boolean hardLimit;

    public LimitStatus getCpu()
    {
        return cpu;
    }

    public void setCpu(final LimitStatus cpu)
    {
        this.cpu = cpu;
    }

    public LimitStatus getRam()
    {
        return ram;
    }

    public void setRam(final LimitStatus ram)
    {
        this.ram = ram;
    }

    public LimitStatus getHd()
    {
        return hd;
    }

    public void setHd(final LimitStatus hd)
    {
        this.hd = hd;
    }

    public LimitStatus getStorage()
    {
        return storage;
    }

    public void setStorage(final LimitStatus storage)
    {
        this.storage = storage;
    }

    public LimitStatus getVlan()
    {
        return vlan;
    }

    public void setVlan(final LimitStatus vlan)
    {
        this.vlan = vlan;
    }

    public LimitStatus getIp()
    {
        return ip;
    }

    public void setIp(final LimitStatus ip)
    {
        this.ip = ip;
    }

    public LimitStatus getRepository()
    {
        return repository;
    }

    public void setRepository(final LimitStatus repository)
    {
        this.repository = repository;
    }

    public String getEntityName()
    {
        return entityName;
    }

    public void setEntityName(final String entityName)
    {
        this.entityName = entityName;
    }

    public TYPE getEntityType()
    {
        return entityType;
    }

    public void setEntityType(final TYPE entityType)
    {
        this.entityType = entityType;
    }

    public Integer getEntityId()
    {
        return entityId;
    }

    public void setEntityId(final Integer entityId)
    {
        this.entityId = entityId;
    }

    public boolean isHardLimit()
    {
        return hardLimit;
    }

    public void setHardLimit(final boolean isHardLimit)
    {
        this.hardLimit = isHardLimit;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
