/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.util;

import java.util.Comparator;

/**
 * Compares an object by a list of properties.
 * 
 * @author ibarrera
 */
public class CompositeComparator
{
    /**
     * Builds a comparator that delegates on a list of comparators.
     * 
     * @param <T> The type of the objects to compare.
     * @param comparators The list of comparators to use.
     * @return The result of the comparison.
     */
    public static <T> Comparator<T> build(final Comparator<T>... comparators)
    {
        return new Comparator<T>()
        {
            @Override
            public int compare(final T o1, final T o2)
            {
                for (Comparator<T> comparator : comparators)
                {
                    int result = comparator.compare(o1, o2);
                    if (result != 0)
                    {
                        return result;
                    }
                }

                return 0;
            }
        };
    }

}
