/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.model.util;

import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:serafin.sedano@abiquo.com">Serafin Sedano</a>
 */
public class StringSplitter
{
    private StringSplitter()
    {
    }

    /**
     * Splits the given string by comma. If no commas a single element with the parameter back is
     * outputted.
     */
    public static List<String> commaSplit(final String s)
    {
        String[] parts = (s == null ? "" : s).trim().replace("\\s*,\\s*", ",").split(",");
        return Arrays.asList(parts);
    }

}
