/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.accounting;

import java.math.BigInteger;

import javax.xml.bind.annotation.XmlRootElement;

import org.joda.time.DateTime;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "accountingeventdetail")
public class AccountingEventDetailDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.accountingeventdetail";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private int idEnterprise;

    public int getIdEnterprise()
    {
        return idEnterprise;
    }

    public void setIdEnterprise(final int idEnterprise)
    {
        this.idEnterprise = idEnterprise;
    }

    private int resourceType;

    public int getResourceType()
    {
        return resourceType;
    }

    public void setResourceType(final int resourceType)
    {
        this.resourceType = resourceType;
    }

    private DateTime startTime;

    public DateTime getStartTime()
    {
        return startTime;
    }

    public void setStartTime(final DateTime startTime)
    {
        this.startTime = startTime;
    }

    private Integer idAccountingEvent;

    public Integer getIdAccountingEvent()
    {
        return idAccountingEvent;
    }

    public void setIdAccountingEvent(final Integer idAccountingEvent)
    {
        this.idAccountingEvent = idAccountingEvent;
    }

    private ResourceTypeDto idAccountingResourceType;

    public ResourceTypeDto getIdAccountingResourceType()
    {
        return idAccountingResourceType;
    }

    public void setIdAccountingResourceType(final ResourceTypeDto idAccountingResourceType)
    {
        this.idAccountingResourceType = idAccountingResourceType;
    }

    private DateTime endTime;

    public DateTime getEndTime()
    {
        return endTime;
    }

    public void setEndTime(final DateTime endTime)
    {
        this.endTime = endTime;
    }

    private int idVirtualMachine;

    public int getIdVirtualMachine()
    {
        return idVirtualMachine;
    }

    public void setIdVirtualMachine(final int idVirtualMachine)
    {
        this.idVirtualMachine = idVirtualMachine;
    }

    private BigInteger resourceUnits;

    public BigInteger getResourceUnits()
    {
        return resourceUnits;
    }

    public void setResourceUnits(final BigInteger resourceUnits)
    {
        this.resourceUnits = resourceUnits;
    }

    private int idVirtualDataCenter;

    public int getIdVirtualDataCenter()
    {
        return idVirtualDataCenter;
    }

    public void setIdVirtualDataCenter(final int idVirtualDataCenter)
    {
        this.idVirtualDataCenter = idVirtualDataCenter;
    }

    private int resourceName;

    public int getResourceName()
    {
        return resourceName;
    }

    public void setResourceName(final int resourceName)
    {
        this.resourceName = resourceName;
    }

    private int idStorageTier;

    public int getIdStorageTier()
    {
        return idStorageTier;
    }

    public void setIdStorageTier(final int idStorageTier)
    {
        this.idStorageTier = idStorageTier;
    }

    private int costCode;

    public int getCostCode()
    {
        return costCode;
    }

    public void setCostCode(final int costCode)
    {
        this.costCode = costCode;
    }

    private int idVirtualApp;

    public int getIdVirtualApp()
    {
        return idVirtualApp;
    }

    public void setIdVirtualApp(final int idVirtualApp)
    {
        this.idVirtualApp = idVirtualApp;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
