/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * @restlink <link rel="enterprise" href="http://example.com/api/admin/enterprises/{enterpriseId}/"
 *           />
 */
@XmlType(propOrder = {"defaultCategory", "erasable", "name", "id"})
@XmlRootElement(name = "category")
public class CategoryDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.category";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * Identifier of the entity
     * 
     * @return id of the Category
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * Name of the category
     * 
     * @return name of the category
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private boolean erasable;

    /**
     * true if the category is erasable
     * 
     * @return
     */
    @NotNull
    public boolean isErasable()
    {
        return erasable;
    }

    public void setErasable(final boolean erasable)
    {
        this.erasable = erasable;
    }

    private boolean defaultCategory;

    /**
     * true if the category is default
     * 
     * @return
     */
    @NotNull
    public boolean isDefaultCategory()
    {
        return defaultCategory;
    }

    public void setDefaultCategory(final boolean defaultCategory)
    {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

}
