/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import java.util.Date;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.ConversionState;
import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "conversion")
@XmlType(propOrder = {"state", "sourceFormat", "sourcePath", "targetFormat", "targetPath",
"targetSizeInBytes", "startTimestamp"})
public class ConversionDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.conversion";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = 2614433637470749771L;

    private String sourceFormat;

    private String sourcePath;

    private Date startTimestamp;

    private ConversionState state;

    private String targetFormat;

    private String targetPath;

    private Long targetSizeInBytes;

    /**
     * DiskFormatType of the template disk file in ''sourcePath''
     * 
     * @output
     */
    @NotNull
    public String getSourceFormat()
    {
        return sourceFormat;
    }

    /**
     * Path relative to the Abiquo repository of the template disk file used as source of the
     * conversion
     * 
     * @output
     */
    @NotNull
    public String getSourcePath()
    {
        return sourcePath;
    }

    /**
     * When the conversion starts
     * 
     * @output
     */
    @NotNull
    public Date getStartTimestamp()
    {
        return startTimestamp;
    }

    /**
     * Result status of the conversion
     * 
     * @output
     */
    @NotNull
    public ConversionState getState()
    {
        return state;
    }

    /**
     * DiskFormatType of the template disk file in ''targetPath''
     * 
     * @output
     */
    @NotNull
    public String getTargetFormat()
    {
        return targetFormat;
    }

    /**
     * Path relative to the Abiquo repository of resulting template disk file
     * 
     * @output
     */
    @NotNull
    public String getTargetPath()
    {
        return targetPath;
    }

    /**
     * Size of the template disk file result in ''targetPath''
     * 
     * @output
     */
    @NotNull
    public Long getTargetSizeInBytes()
    {
        return targetSizeInBytes;
    }

    public void setSourceFormat(final String sourceFormat)
    {
        this.sourceFormat = sourceFormat;
    }

    public void setSourcePath(final String sourcePath)
    {
        this.sourcePath = sourcePath;
    }

    public void setStartTimestamp(final Date startTimestamp)
    {
        this.startTimestamp = startTimestamp;
    }

    public void setState(final ConversionState state)
    {
        this.state = state;
    }

    public void setTargetFormat(final String targetFormat)
    {
        this.targetFormat = targetFormat;
    }

    public void setTargetPath(final String targetPath)
    {
        this.targetPath = targetPath;
    }

    public void setTargetSizeInBytes(final Long targetSizeInBytes)
    {
        this.targetSizeInBytes = targetSizeInBytes;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
