/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.task.TaskDto;

@XmlRootElement(name = "datacenterRepository")
@XmlType(propOrder = {"name", "repositoryLocation", "repositoryCapacityMb",
"repositoryRemainingMb", "error", "lastTask"})
public class DatacenterRepositoryDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 6344939071248048966L;

    private static final String TYPE = "application/vnd.abiquo.datacenterrepository";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_26 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_26;

    public static final String MEDIA_TYPE_27 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_27;

    public static final String MEDIA_TYPE_28 = MEDIA_TYPE + VERSION_PARAM + API_VERSION_28;

    public static final String MEDIA_TYPE_XML_22 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_22;

    public static final String MEDIA_TYPE_XML_23 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_23;

    public static final String MEDIA_TYPE_XML_24 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_24;

    public static final String MEDIA_TYPE_XML_26 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_26;

    public static final String MEDIA_TYPE_XML_27 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_27;

    public static final String MEDIA_TYPE_XML_28 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_28;

    private String name;

    private String error;

    private String repositoryLocation;

    private Long repositoryRemainingMb;

    private Long repositoryCapacityMb;

    /** to expand */
    private TaskDto lastTask;

    /**
     * Name of the datacenter repository
     * 
     * @return Name of the datacenter repository
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Any error in repository
     * 
     * @return Returns if there are errors in repository
     */
    public String getError()
    {
        return error;
    }

    public void setError(final String error)
    {
        this.error = error;
    }

    /**
     * The repository location
     * 
     * @return the repository location
     */
    @NotNull
    public String getRepositoryLocation()
    {
        return repositoryLocation;
    }

    public void setRepositoryLocation(final String repositoryLocation)
    {
        this.repositoryLocation = repositoryLocation;
    }

    /**
     * Remaining capacity of the repository in MB
     * 
     * @output
     * @return Remaining capacity of the repository in MB
     */
    public Long getRepositoryRemainingMb()
    {
        return repositoryRemainingMb;
    }

    public void setRepositoryRemainingMb(final Long repositoryRemainingMb)
    {
        this.repositoryRemainingMb = repositoryRemainingMb;
    }

    /**
     * Capacity of repository in MB
     * 
     * @output
     * @return The capacity of repository in MB
     */
    public Long getRepositoryCapacityMb()
    {
        return repositoryCapacityMb;
    }

    public void setRepositoryCapacityMb(final Long repositoryCapacityMb)
    {
        this.repositoryCapacityMb = repositoryCapacityMb;
    }

    /**
     * Expanded last refresh task (if present)
     * 
     * @output
     * @return The task to track the last repository refresh
     */
    public TaskDto getLastTask()
    {
        return lastTask;
    }

    public void setLastTask(final TaskDto lastTask)
    {
        this.lastTask = lastTask;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
