/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "diskformtattype")
@XmlType(propOrder = {"uri", "description", "alias"})
public class DiskFormatTypeDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.diskformattype";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private String uri;

    private String description;

    private String alias;

    private static final long serialVersionUID = 1L;

    /**
     * URI of the Disk Format type
     * 
     * @Output
     * @return URI of the Disk Format type
     */
    public String getUri()
    {
        return uri;
    }

    public void setUri(final String Uri)
    {
        uri = Uri;
    }

    /**
     * Description of the type
     * 
     * @Output
     * @return Description of the type
     */
    public String getDescription()
    {
        return description;
    }

    public void setDescription(final String Description)
    {
        description = Description;
    }

    /**
     * Alias of the disk format type
     * 
     * @Output
     * @return Alias of the disk format type
     */
    public String getAlias()
    {
        return alias;
    }

    public void setAlias(final String Alias)
    {
        alias = Alias;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
