/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.DiskControllerType;
import com.abiquo.model.enumerator.EthernetDriverType;
import com.abiquo.model.enumerator.OSType;
import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "templateDefinition")
@XmlType(propOrder = {"id", "url", "name", "description", "productName", "productVendor",
"productUrl", "productVersion", "iconUrl", "diskFormatType", "diskFileSize", "loginUser",
"loginPassword", "osType", "osVersion", "ethernetDriverType", "diskControllerType",
"diskController"})
public class TemplateDefinitionDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.templatedefinition";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = -2655629613600887997L;

    private String description;

    private DiskControllerType diskControllerType;

    private String diskController;

    private long diskFileSize;

    private String diskFormatType;

    private EthernetDriverType ethernetDriverType;

    private String iconUrl;

    private Integer id;

    private String loginPassword;

    private String loginUser;

    private String name;

    private OSType osType;

    private String osVersion;

    private String productName;

    private String productUrl;

    private String productVendor;

    private String productVersion;

    private String url;

    /**
     * Description of the template definition
     */
    @NotNull
    public String getDescription()
    {
        return description;
    }

    /**
     * Kind of controller type (IDE or SCSI)
     * <p>
     * *NOTE* not all the hypervisor plugins will use this info
     */
    public DiskControllerType getDiskControllerType()
    {
        return diskControllerType;
    }

    /** Controller implementation to use in disks. Optional. */
    public String getDiskController()
    {
        return diskController;
    }

    /**
     * The disk file size in MegaBytes of the disk file
     */
    @NotNull
    public long getDiskFileSize()
    {
        return diskFileSize;
    }

    /**
     * Disk format type of the disk file @see {@link DiskFormatType}
     */
    @NotNull
    public String getDiskFormatType()
    {
        return diskFormatType;
    }

    /**
     * Kind of network driver (PCNet32, VMXNET3 or E1000)
     * <p>
     * *NOTE* not all the hypervisor plugins will use this info. By default all use E1000
     */
    public EthernetDriverType getEthernetDriverType()
    {
        return ethernetDriverType;
    }

    /**
     * The URI of the icon of the template definition
     */
    public String getIconUrl()
    {
        return iconUrl;
    }

    /**
     * Identifier of the template definition
     * 
     * @output
     */
    @NotNull
    public Integer getId()
    {
        return id;
    }

    /**
     * Default login password
     */
    public String getLoginPassword()
    {
        return loginPassword;
    }

    /**
     * Default login user
     */
    public String getLoginUser()
    {
        return loginUser;
    }

    /**
     * Name of the template definition
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Kind of Operating System
     */
    public OSType getOsType()
    {
        return osType;
    }

    /**
     * Additional info for the ''osType''
     */
    public String getOsVersion()
    {
        return osVersion;
    }

    /**
     * Additional info about the installed software
     */
    public String getProductName()
    {
        return productName;
    }

    /**
     * Link to additional info about the installed software
     */
    public String getProductUrl()
    {
        return productUrl;
    }

    /**
     * Additional info about the installed software
     */
    public String getProductVendor()
    {
        return productVendor;
    }

    /**
     * Additional version info about the installed software
     */
    public String getProductVersion()
    {
        return productVersion;
    }

    /**
     * URL of the source .ovf Envelope document.
     */
    @NotNull
    public String getUrl()
    {
        return url;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public void setDiskControllerType(final DiskControllerType diskControllerType)
    {
        this.diskControllerType = diskControllerType;
    }

    public void setDiskController(final String diskController)
    {
        this.diskController = diskController;
    }

    public void setDiskFileSize(final long diskFileSize)
    {
        this.diskFileSize = diskFileSize;
    }

    public void setDiskFormatType(final String type)
    {
        this.diskFormatType = type;
    }

    public void setEthernetDriverType(final EthernetDriverType ethernetDriverType)
    {
        this.ethernetDriverType = ethernetDriverType;
    }

    public void setIconUrl(final String iconUrl)
    {
        this.iconUrl = iconUrl;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setLoginPassword(final String loginPassword)
    {
        this.loginPassword = loginPassword;
    }

    public void setLoginUser(final String loginUser)
    {
        this.loginUser = loginUser;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public void setOsType(final OSType osType)
    {
        this.osType = osType;
    }

    public void setOsVersion(final String osVersion)
    {
        this.osVersion = osVersion;
    }

    public void setProductName(final String productName)
    {
        this.productName = productName;
    }

    public void setProductUrl(final String productUrl)
    {
        this.productUrl = productUrl;
    }

    public void setProductVendor(final String productVendor)
    {
        this.productVendor = productVendor;
    }

    public void setProductVersion(final String productVersion)
    {
        this.productVersion = productVersion;
    }

    public void setUrl(final String url)
    {
        this.url = url;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
