/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "templateDefinitionList")
@XmlType(propOrder = {"id", "name", "url", "templateDefinitions"})
public class TemplateDefinitionListDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.templatedefinitionlist";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = -394035712365582338L;

    private Integer id;

    private String name;

    private String url;

    private TemplateDefinitionsDto templateDefinitions;

    /**
     * Identifier of the template definition list
     * 
     * @output
     */
    @NotNull
    public Integer getId()
    {
        return id;
    }

    /**
     * Name of the template definition list
     * 
     * @output
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * The URL of the template definition list public ''ovfindex.xml'' source.
     * <p>
     * When this attribute is present the its possible to request a template definition list refresh
     * (fetch the OVFs again)
     */
    public String getUrl()
    {
        return url;
    }

    /**
     * The template definitions of the list
     */
    public TemplateDefinitionsDto getTemplateDefinitions()
    {
        return templateDefinitions; // TODO GET or CREATE
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public void setTemplateDefinitions(final TemplateDefinitionsDto ovfPackages)
    {
        this.templateDefinitions = ovfPackages;
    }

    public void setUrl(final String url)
    {
        this.url = url;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
