/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The materialization state of an {@link TemplateDefinition} of a given {@link Datacenter} and
 * Enterprise
 */
/**
 * support deprecated functionality. Now instead of requesting the state of a templatedefinition,
 * the user can track the download task.
 */
@Deprecated
@XmlType
@XmlRootElement(name = "templateState")
public class TemplateStateDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -4115162963051770344L;

    private static final String TYPE = "application/vnd.abiquo.templatestate";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /**
     * Original location of the {@link TemplateDefinition}. Identify the entity combined with the
     * {@link Enterprise} identifier (id of the ApplianceManager EnterpriseRepository). Datacenter
     * identifier is implicit in the ApplianceManager context.
     */
    protected String ovfId;

    /** Current status in the enterprise repository */

    // @XmlElement(name = "status")
    protected TemplateStatusEnumType status;

    /**
     * If status == DOWNLOADING reports the current creation progress (based on bytes lefts to read
     * from the remote repository)
     */
    protected Double downloadingProgress;

    /**
     * If status == ERROR reports the creation error cause (content of ''deploy.error'' file)
     */
    protected String errorCause;

    protected String masterOvf;

    public TemplateStateDto()
    {

    }

    public TemplateStateDto(final String ovfId, final TemplateStatusEnumType status)
    {
        this.ovfId = ovfId;
        this.status = status;
    }

    /** creates a DOWNLOADING state. */
    public TemplateStateDto(final String ovfId, final Double downloadingProgress)
    {
        this.ovfId = ovfId;
        this.status = TemplateStatusEnumType.DOWNLOADING;
        this.downloadingProgress = downloadingProgress;
    }

    /** creates an ERROR state. */
    public TemplateStateDto(final String ovfId, final String errorCause)
    {
        this.ovfId = ovfId;
        this.status = TemplateStatusEnumType.ERROR;
        this.errorCause = errorCause;
    }

    public String getOvfId()
    {
        return ovfId;
    }

    public void setOvfId(final String ovfId)
    {
        this.ovfId = ovfId;
    }

    public TemplateStatusEnumType getStatus()
    {
        return status;
    }

    public void setStatus(final TemplateStatusEnumType status)
    {
        this.status = status;
    }

    public Double getDownloadingProgress()
    {
        return downloadingProgress;
    }

    public void setDownloadingProgress(final Double downloadingProgress)
    {
        this.downloadingProgress = downloadingProgress;
    }

    public String getErrorCause()
    {
        return errorCause;
    }

    public void setErrorCause(final String errorCause)
    {
        this.errorCause = errorCause;
    }

    public String getMasterOvf()
    {
        return masterOvf;
    }

    public void setMasterOvf(final String masterOvf)
    {
        this.masterOvf = masterOvf;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @XmlEnum
    @XmlType(name = "templatestatusenumtype")
    public enum TemplateStatusEnumType
    {
        /** ovf package not found in the enterprise repository */
        NOT_DOWNLOAD,
        /** currently being created **/
        DOWNLOADING,
        /** ovf package installed in the current enterprise repository. */
        DOWNLOAD,
        /** error during the creation */
        ERROR;

        public String value()
        {
            return name();
        }

        public static TemplateStatusEnumType fromValue(final String v)
        {
            return valueOf(v);
        }
    }
}
