/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import java.util.Date;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.enumerator.DiskControllerType;
import com.abiquo.model.enumerator.EthernetDriverType;
import com.abiquo.model.enumerator.OSType;
import com.abiquo.model.enumerator.VMTemplateState;
import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "virtualMachineTemplate")
@XmlType(propOrder = {"id", "name", "description", "osType", "osVersion", "path", "diskFormatType",
"diskFileSize", "cpuRequired", "coresPerSocket", "ramRequired", "hdRequired", "shared", "state",
"costCode", "creationDate", "creationUser", "chefEnabled", "iconUrl", "loginUser", "loginPassword",
"ethernetDriverType", "diskControllerType", "diskController"})
public class VirtualMachineTemplateDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -373594792872922803L;

    private static final String TYPE = "application/vnd.abiquo.virtualmachinetemplate";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private boolean chefEnabled;

    private Integer costCode;

    private Integer cpuRequired;

    private Integer coresPerSocket;

    private Date creationDate;

    private String creationUser;

    private String description;

    private DiskControllerType diskControllerType;

    private String diskController;

    private Long diskFileSize;

    private String diskFormatType;

    private EthernetDriverType ethernetDriverType;

    private Long hdRequired;

    private String iconUrl;

    private Integer id;

    private String loginPassword;

    private String loginUser;

    private String name;

    private OSType osType;

    private String osVersion;

    private String path;

    private Integer ramRequired;

    private boolean shared;

    private VMTemplateState state;

    /**
     * Cost code identifier
     */
    public Integer getCostCode()
    {
        return costCode;
    }

    /**
     * The number of CPU required
     */
    @NotNull
    public Integer getCpuRequired()
    {
        return cpuRequired;
    }

    /**
     * Optional ratio to distribute cores in sockets (sockets = cpu / coresPerSocket).
     * <p>
     * This attribute MUST be divisor of CPU.
     */
    public Integer getCoresPerSocket()
    {
        return coresPerSocket;
    }

    /**
     * Creation date
     * 
     * @output
     */
    public Date getCreationDate()
    {
        return creationDate;
    }

    /**
     * Nickname of the creation user
     * 
     * @output
     */
    public String getCreationUser()
    {
        return creationUser;
    }

    /**
     * Description of the virtual machine template
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Kind of controller type (IDE or SCSI)
     * <p>
     * *NOTE* not all the hypervisor plugins will use this info
     */
    public DiskControllerType getDiskControllerType()
    {
        return diskControllerType;
    }

    /** Controller implementation to use in disks. Optional. */
    public String getDiskController()
    {
        return diskController;
    }

    /**
     * The disk file size in Bytes of the virtual machine template disk file
     * 
     * @output
     */
    @NotNull
    public Long getDiskFileSize()
    {
        return diskFileSize;
    }

    /**
     * Disk format type of the virtual machine template @see {@link DiskFormatType}
     */
    @NotNull
    public String getDiskFormatType()
    {
        return diskFormatType;
    }

    /**
     * Kind of network driver (PCNet32, VMXNET3 or E1000)
     * <p>
     * *NOTE* not all the hypervisor plugins will use this info. By default all use E1000
     */
    public EthernetDriverType getEthernetDriverType()
    {
        return ethernetDriverType;
    }

    /**
     * The HD required in bytes for the virtual machine template (Primary disk capacity)
     */
    public Long getHdRequired()
    {
        return hdRequired;
    }

    /**
     * The URI of the icon of the virtual machine template
     */
    public String getIconUrl()
    {
        return iconUrl;
    }

    /**
     * Identifier of the virtual machine template
     * 
     * @output
     */
    @NotNull
    public Integer getId()
    {
        return id;
    }

    /**
     * Default login password
     */
    public String getLoginPassword()
    {
        return loginPassword;
    }

    /**
     * Default login user
     */
    public String getLoginUser()
    {
        return loginUser;
    }

    /**
     * Name of the virtual machine template
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * Kind of Operating System
     */
    public OSType getOsType()
    {
        return osType;
    }

    /**
     * Additional info for the ''osType''
     */
    public String getOsVersion()
    {
        return osVersion;
    }

    /**
     * Path relative to the Abiquo datacenter repository of the virtual machine template disk file
     * 
     * @output
     */
    @NotNull
    public String getPath()
    {
        return path;
    }

    /**
     * The RAM in MegaBytes required for the virtual machine template
     */
    @NotNull
    public Integer getRamRequired()
    {
        return ramRequired;
    }

    /**
     * Current state of the virtual machine template (based on the tasks)
     * 
     * @output
     */
    public VMTemplateState getState()
    {
        return state;
    }

    /**
     * Determine if its suitable for the Chef integration feature
     */
    public boolean isChefEnabled()
    {
        return chefEnabled;
    }

    /**
     * Determine if virtual machine template can be used in other enterprises
     */
    @NotNull
    public boolean isShared()
    {
        return shared;
    }

    public void setChefEnabled(final boolean chefEnabled)
    {
        this.chefEnabled = chefEnabled;
    }

    public void setCostCode(final Integer costCode)
    {
        this.costCode = costCode;
    }

    public void setCpuRequired(final Integer cpuRequired)
    {
        this.cpuRequired = cpuRequired;
    }

    public void setCoresPerSocket(final Integer coresPerSocket)
    {
        this.coresPerSocket = coresPerSocket;
    }

    public void setCreationDate(final Date creationDate)
    {
        this.creationDate = creationDate;
    }

    public void setCreationUser(final String creationUser)
    {
        this.creationUser = creationUser;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public void setDiskControllerType(final DiskControllerType diskControllerType)
    {
        this.diskControllerType = diskControllerType;
    }

    public void setDiskController(final String diskController)
    {
        this.diskController = diskController;
    }

    public void setDiskFileSize(final Long diskFileSize)
    {
        this.diskFileSize = diskFileSize;
    }

    public void setDiskFormatType(final String diskFormatType)
    {
        this.diskFormatType = diskFormatType;
    }

    public void setEthernetDriverType(final EthernetDriverType ethernetDriverType)
    {
        this.ethernetDriverType = ethernetDriverType;
    }

    public void setHdRequired(final Long hdRequired)
    {
        this.hdRequired = hdRequired;
    }

    public void setIconUrl(final String iconUrl)
    {
        this.iconUrl = iconUrl;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setLoginPassword(final String loginPassword)
    {
        this.loginPassword = loginPassword;
    }

    public void setLoginUser(final String loginUser)
    {
        this.loginUser = loginUser;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public void setOsType(final OSType osType)
    {
        this.osType = osType;
    }

    public void setOsVersion(final String osVersion)
    {
        this.osVersion = osVersion;
    }

    public void setPath(final String path)
    {
        this.path = path;
    }

    public void setRamRequired(final Integer ramRequired)
    {
        this.ramRequired = ramRequired;
    }

    public void setShared(final boolean shared)
    {
        this.shared = shared;
    }

    public void setState(final VMTemplateState state)
    {
        this.state = state;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
