/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.appslibrary;

import java.io.Serializable;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Hold parameters to request a persistent virtual machine creation.
 * <p>
 * Tier link can be replaced using a Volume link.
 * 
 * @restlink <link rel="virtualmachinetemplate" href=
 *           "http://example.com/api/admin/enterprises/{enterpriseId}/datacenterrepositories/{datacenterId}/virtualmachinetemplates/{virtualmachinetemplateId}"
 *           />
 * @restlink <link rel="virtualdatacenter" href=
 *           "http://example.com/api/cloud/virtualdatacenters/{virtualdatacenterId}" />
 * @restlink <link rel="tier"href=
 *           "http://example.com/api/cloud/virtualdatacenters/{virtualdatacenterId}/tiers/{tierId}"
 *           />
 * @author Sergi Castro
 */
@XmlRootElement(name = "virtualmachinetemplatepersistent")
@XmlType(propOrder = {"persistentTemplateName", "persistentVolumeName"})
public class VirtualMachineTemplatePersistentDto extends SingleResourceTransportDto implements
    Serializable
{
    private static final String TYPE = "application/vnd.abiquo.virtualmachinetemplatepersistent";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = -1458892631967828227L;

    private String persistentTemplateName;

    private String persistentVolumeName;

    /**
     * Name for the new persistent virtual machine template
     */
    @NotNull
    public String getPersistentTemplateName()
    {
        return persistentTemplateName;
    }

    /**
     * Name of the new volume to hold the persistent virtual machine template
     * <p>
     * if is null will be used the value of persistentTemplateName and if the storage link is a
     * volume link will be omitted
     */
    public String getPersistentVolumeName()
    {
        return persistentVolumeName;
    }

    public void setPersistentTemplateName(final String persistentTemplateName)
    {
        this.persistentTemplateName = persistentTemplateName;
    }

    public void setPersistentVolumeName(final String persistentVolumeName)
    {
        this.persistentVolumeName = persistentVolumeName;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
